<?php
/*
Plugin Name: Sumo Oyakata
Plugin URI: https://blog.tremlas.com/wordpress-plugins/sumo-oyakata-plugin-details/
Description: Adds a shortcode that inserts the Sumo Oyakata game
Version: 3.326.0
Author: David Vines
Author URI: http://tremlas.com
License: GPLv2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/
/* © Copyright 2021 David Vines

sumoOyakata is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

sumoOyakata is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with sumoOyakata. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
*/

include_once 'common.php';

/**
 * Shortcode to add the version of the plugin
 */
function djv_sumoOyakata_sumoOyakataVersion_shortcode() {
	return 'Sumo Oyakata Version 3.326.0';
}
add_shortcode( 'sumoOyakataVersion', 'djv_sumoOyakata_sumoOyakataVersion_shortcode' );

/**
 * Add the "Sumo Oyakata". Only one per page is supported.
 */

// Now for a shortcode that can be used to get links and/or tables for the characters
function djv_sumoOyakata_shortcode( $attr, $content = null ) {
	$plugin_url = plugin_dir_url(__FILE__);
	wp_enqueue_script('djv_common_exceptionbox', $plugin_url.'js/util/exceptionbox.js', array(), '3.0.2' );
	wp_enqueue_script('djv_common_modaldialog', $plugin_url.'js/util/modaldialog.js', array(), '3.0.2' );
	wp_enqueue_script('djv_sumoOyakata_rot', $plugin_url.'js/rot/rot.min.js', array(), '3.326.0' );
	wp_enqueue_script('djv_sumoOyakata_names', $plugin_url.'js/sumoOyakata/names.js', array(), '3.326.0' );
	wp_enqueue_script('djv_sumoOyakata_rikishi', $plugin_url.'js/sumoOyakata/rikishi.js', array('djv_sumoOyakata_names'), '3.326.0' );
	wp_enqueue_script('djv_sumoOyakata_result', $plugin_url.'js/sumoOyakata/result.js', array(), '3.326.0' );
	wp_enqueue_script('djv_sumoOyakata_move', $plugin_url.'js/sumoOyakata/move.js', array(), '3.326.0' );
	wp_enqueue_script('djv_sumoOyakata_state', $plugin_url.'js/sumoOyakata/state.js', array(), '3.326.0' );
	wp_enqueue_script('djv_sumoOyakata_bout', $plugin_url.'js/sumoOyakata/bout.js', array('djv_sumoOyakata_rot','djv_sumoOyakata_rikishi','djv_sumoOyakata_result','djv_sumoOyakata_move','djv_sumoOyakata_state'), '3.326.0' );

	// The game requires the custom elements to have been defined before it can init - hence the dependencies listed here
	wp_enqueue_script('djv_sumoOyakata_game',   $plugin_url.'js/sumoOyakata/game.js',  array('djv_common_exceptionbox', 'djv_common_modaldialog'), '3.326.0' );

	wp_enqueue_style('djv_sumoOyakataStyle', $plugin_url.'css/sumoOyakata.css', array(), '3.326.0' );

	$file = plugin_dir_path(__FILE__);
	$filecontent = file_get_contents($file.'/html/sumoOyakata.html');

	return $filecontent;
}

add_shortcode( 'sumoOyakata', 'djv_sumoOyakata_shortcode' );

/* --------------------- Functions for updating plugins ------------------------------ */
function djv_sumoOyakata_pre_set_site_transient_update_plugins( $transient ) {
 $id = 'sumoOyakata/sumoOyakata.php';
 $name = 'Sumo Oyakata';
 $slug = 'sumoOyakata';
 return djv_plugin_pre_set_site_transient( $transient, $id, $name, $slug, '3.326.0' );
}
add_filter( 'pre_set_site_transient_update_plugins', 'djv_sumoOyakata_pre_set_site_transient_update_plugins' );

function djv_sumoOyakata_plugin_info( $result, $action, $args ) {
	$name = 'Sumo Oyakata';
	$slug = 'sumoOyakata';
	if ( 'plugin_information' !== $action ) {
		return $result;
	}
	if ( $slug !== $args->slug) {
		return $result;
	}
	return djv_plugin_get_remote_update_info( $name, $slug );
}
add_filter( 'plugins_api', 'djv_sumoOyakata_plugin_info', 10, 3 );

?>