/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* global window, ErrorEvent, customElements */
/* exported ExceptionBox */
class ExceptionBox extends HTMLElement {
	constructor() {
		super();

		this.append(ExceptionBox.template.content.cloneNode(true));

		this._div = this.querySelector("div");
		this._code = this.querySelector("code");

		// Start listening for error events
		window.addEventListener("error", (event) => { this.handleErrorEvent(event); });
	}

	handleErrorEvent(ex) {
			let text = "No exception??";
			let error = null;
			/* Get the basic error text*/
			if (ex instanceof Error) {
				error = ex;
				text = ex.name + " : " + ex.message;
			} else if (ex instanceof ErrorEvent) {
				error = ex.error;
				text = ex.message;
			} else if (ex) {
				text = ex.toString();
			}
			/* Get the stack trace (if we can find it) */
			if (error && (error.stack || error.stacktrace)) {
				text += '\n' + (error.stack || error.stacktrace || '');
			} else if (ex.filename && ex.lineno && ex.colno) {
				text +=  `\nunknown@${ex.filename}:${ex.lineno}:${ex.colno}`;
			}
			/* Pretty up the stack trace */
			let lines = text
						.split('\n')
						.map(line => line.replace(/@.*\/sumoOyakata\/js\//, " in ").replace(/\?ver=[0-9\.]*:/, ":"))
						.filter(line => line.length > 0);

			this._div.style="display: block;";
			this._code.replaceChildren();
			for(let line of lines) {
				this._code.append(line,document.createElement("br"));
			}
			debugger; // jshint ignore:line
	}
}

ExceptionBox.template = document.createElement("template");
ExceptionBox.template.innerHTML = `
<style>
exception-box { width: 100%; display: inline-block; position: relative;}
exception-box code { white-space: pre; display: block; }
exception-box p { font-weight: bold; color: red; }
</style>
<div style="display: none;">
<p>A javascript exception has occurred:</p>
<pre>
<code>
</code>
</pre>
</div>
`;
customElements.define("exception-box",ExceptionBox);