/*!
 * © 2021 David Vines
 *
 * sumoOyakata is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * sumoOyakata is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with sumoOyakata. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */

/* exported Result */
class Result {
	constructor() {
		this._winner = null;
		this._loser = null;
		this._text = [];
		this._style = [];
		this._nextlineisdebug = false;
		this._newline = true;
	}
	setWinner(winner) {
		this._winner = winner;
	}
	getWinner() {
		return this._winner;
	}
	setLoser(loser) {
		this._loser = loser;
	}
	getLoser() {
		return this._loser;
	}
	getText() {
		return this._text;
	}
	getStyle() {
		return this._style;
	}
	newline(debug) {
		this._newline = true;
		this._nextlineisdebug = debug;
	}
	addText(text) {
		if (this._newline) {
			this._text.push(text);
			this._style.push(this._nextlineisdebug ? "debug" : "");
			this._newline = false;
		} else {
			this._text[this._text.length-1] = this._text[this._text.length-1] + " " + text;
		}
	}
}
