/**
 * Theme functions file
 *
 * Contains searchbar toggle.
 *
 */

( function( $ ) {
	$( function() {
		// For Search toggle.
		$( '.search-toggle' ).on( 'click', function( event ) {
			var self    = $( this ),
				wrapper = $( '.search-inner' );

			self.toggleClass( 'active' );
			wrapper.toggleClass( 'hide' );

			if ( self.is( '.active' ) || $( '.search-toggle .screen-reader-text' )[0] === event.target ) {
				wrapper.find( '#q' ).focus();
			}
		} );
		// For left and right sidebars
		$( '#leftsidebartoggle, #rightsidebartoggle').on( 'click' ,function( event ) {
			var self    = $( this );
			var content = $( '#content');
			var leftsidebartoggle = $( '#leftsidebartoggle' );
			var rightsidebartoggle = $( '#rightsidebartoggle' );
			self.toggleClass( 'open' );
			self.toggleClass( 'closed' );
			self.addClass( 'touched' );
			content.removeClass( 'twosidebars onlyleftsidebar onlyrightsidebar nosidebars' );
			if (leftsidebartoggle.hasClass('open')) {
				if (rightsidebartoggle.hasClass('open')) {
					content.addClass('twosidebars');
				} else {
					content.addClass('onlyleftsidebar');
				}
			} else {
				if (rightsidebartoggle.hasClass('open')) {
					content.addClass('onlyrightsidebar');
				} else {
					content.addClass('nosidebars');
				}
			}
		} );
	} );
} )( jQuery );

const setResizeHandler = function(callback, timeout) {
	var timer_id ;
	window.addEventListener("resize", function() {
		if(timer_id) {
			clearTimeout(timer_id);
			timer_id = null;
		}
		timer_id = setTimeout(function() {
			timer_id = null;
			callback();
		}, timeout);
	});
	// And make an initial callback call too
	callback();
};

// resize handler
const onResize = function() {
	return function() {
		// Work out the body width
		let wide = window.matchMedia("(min-width: 1000px)").matches;
		let thinner = window.matchMedia("(min-width: 760px) and (max-width: 1000px)").matches;
		let thin = window.matchMedia("(max-width: 760px)").matches;
		let content = document.getElementById('content');
		let leftsidebartoggle = document.getElementById('leftsidebartoggle');
		let rightsidebartoggle = document.getElementById('rightsidebartoggle');
		// If the width greater than 1000px AND the sidebars haven't been touched, make them open
		if (wide && !leftsidebartoggle.classList.contains('touched')) {
			leftsidebartoggle.classList.add('open'); leftsidebartoggle.classList.remove('closed');
		}
		if (wide && !rightsidebartoggle.classList.contains('touched')) {
			rightsidebartoggle.classList.add('open'); rightsidebartoggle.classList.remove('closed');
		}
		// If the width is between 760 and 1000px AND the left sidebar hasn't been touched make it closed
		if (thinner && !leftsidebartoggle.classList.contains('touched')) {
			leftsidebartoggle.classList.remove('open'); leftsidebartoggle.classList.add('closed');
		}
		// If the width is 760px or less AND the sidebars haven't been touched make them closed
		if (thin && !leftsidebartoggle.classList.contains('touched')) {
			leftsidebartoggle.classList.remove('open'); leftsidebartoggle.classList.add('closed');
		}
		if (thin && !rightsidebartoggle.classList.contains('touched')) {
			rightsidebartoggle.classList.remove('open'); rightsidebartoggle.classList.add('closed');
		}
		// Determine the content class based on the state of the sidebars
		content.classList.remove('twosidebars','onlyleftsidebar','onlyrightsidebar','nosidebars');
		if (leftsidebartoggle.classList.contains('open')) {
			if (rightsidebartoggle.classList.contains('open')) {
				content.classList.add('twosidebars');
			} else {
				content.classList.add('onlyleftsidebar');
			}
		} else {
			if (rightsidebartoggle.classList.contains('open')) {
				content.classList.add('onlyrightsidebar');
			} else {
				content.classList.add('nosidebars');
			}
		}
	};
};
setResizeHandler(onResize(), 100);
