<?php
/**
 * @since caporil 3.226.0
 *
 * Intended to be included in the various attachment php's to provide common logic
 * for the file metadata sections
 *
 * Expected variables to be set
 * $post - the wordpress post we're working on
 * $text_File - The word (or phrase) to be used in the heading for the metadata (i.e., it is expected to be capitalised)
 * $text_file - The word for the filetype to be used in text
 * $imageMeta (optional) - The image metadata if the attachment is an image
 */
?>
<h3><?php echo $text_File; ?> Metadata</h3>
<dl>
<dt>Mimetype</dt><dd><?php echo get_post_mime_type( $post->ID ); ?></dd>
<?php
if  (isset( $imageMeta) ) {
	echo "<dt>Image Size</dt><dd>";
	if ( $imageScaled ) {
		$origSize = wp_getimagesize( $imageOriginalFile );
		echo $origSize[0] . "x" . $origSize[1];
	} else {
		echo $imageMeta['width'] . "x" . $imageMeta['height'];
	}
	echo "<p>Other Sizes: ";
	if ( $imageScaled ) {
		echo wp_get_attachment_link( $post->ID, '', false, false, "scaled(" . $imageMeta['width'] . "x" .$imageMeta['height'] . ")" ) . " " ;
	}
	foreach( $imageMeta['sizes'] as $sizeName => $size) {
		echo '<a href="' . image_downsize( $post->ID, $sizeName )[0] . '">' . $sizeName . "(" . $size['width'] . "x" . $size['height'] . ")</a> ";
	}
	echo "</dd>";
	if (isset( $imageMeta['image_meta']['created_timestamp'] ) && $imageMeta['image_meta']['created_timestamp'] !== '0' && $imageMeta['image_meta']['created_timestamp'] !== 0 ) {
		echo "<dt>Image created/taken</dt><dd>" . wp_date( get_option( 'date_format' ), $imageMeta['image_meta']['created_timestamp'] );
		if (isset( $imageMeta['image_meta']['camera'] ) && $imageMeta['image_meta']['camera'] !== '') {
			$camera = $imageMeta['image_meta']['camera'];
			if ( $camera == "X6-00" ) $camera = "Nokia X6-00 Mobile Phone";
			if ( $camera == "GT-I8190N" ) $camera = "Samsung S III mini Mobile Phone";
			if ( $camera == "SM-G903F" ) $camera = "Samsung S5 Neo Mobile Phone";
			if ( $camera == "SM-G965F" ) $camera = "Samsung S9+ Mobile Phone";
			echo " taken with " . $camera;
		}
		echo "</dd>";
	}
	if (isset( $imageMeta['image_meta']['focal_length'] ) && $imageMeta['image_meta']['focal_length'] !== '0' && $imageMeta['image_meta']['focal_length'] !== 0 ) {
		echo "<dt>Focal Length</dt><dd>" . $imageMeta['image_meta']['focal_length'] . "</dd>";
	}
	if (isset( $imageMeta['image_meta']['iso'] ) && $imageMeta['image_meta']['iso'] !== '0' && $imageMeta['image_meta']['iso'] !== 0 ) {
		echo "<dt>ISO</dt><dd>" . $imageMeta['image_meta']['iso'] . "</dd>";
	}
	if (isset( $imageMeta['image_meta']['shutter_speed'] ) && $imageMeta['image_meta']['shutter_speed'] !== '0' && $imageMeta['image_meta']['shutter_speed'] !== 0 ) {
		echo "<dt>Shutter Speed</dt><dd>" . $imageMeta['image_meta']['shutter_speed'] . "</dd>";
	}
}
$alttext = get_post_meta($post->ID, '_wp_attachment_image_alt', true);
$caption = get_the_excerpt();
$descrip = get_the_content();
if( is_string( $alttext ) && $alttext !== '') {
	echo "<dt>Alt Text</dt><dd>" . $alttext . "</dd>";
}
if( is_string( $caption ) && $caption !== '' && trim(strip_tags($descrip)) !== trim(strip_tags($caption)) ) {
	echo "<dt>Caption</dt><dd>" . get_the_excerpt() . "</dd>";
}
if( is_string( $descrip ) && $descrip !== '' ) {
	echo "<dt>Description</dt><dd>" . get_the_content() . "</dd>";
}
$terms = get_the_terms( $post->ID, 'attachment_tag' );
if ( $terms && ! is_wp_error( $terms ) ) {
	$mine = false;
	$ours = false;
	$romsey = false;
	$axiu = false;
	foreach ( $terms as $term ) {
		if ( $term->name == 'sole-copyright-owner-me' ) {
			$mine = true;
		} else if ( $term->name == 'copyright-owners-tina+chris+me+zyg' ) {
			$ours = true;
		} else if ( $term->name == 'romsey-plugin' ) {
			$romsey = true;
		} else if ( $term->name == 'Axiu' ) {
			$axiu =true;
		} else if ( str_starts_with( $term->name, 'copyright-first-year-' ) ) {
			$publish = substr( $term->name, 21 );
		}
	}

	if (!isset( $publish) || strcmp($publish,get_the_date( 'Y' )) == 0) {
		$publish = get_the_date( 'Y' );
	} else {
		$publish = $publish . ', ' . get_the_date( 'Y' );
	}

	echo "<dt>Copyright status</dt><dd>";
	if ( $mine ) {
		echo "© David Vines " .  $publish . ". ";
		$prefix = "You can use this " . $text_file . " if you abide by the terms of the ";
	} else if ( $ours ) {
		echo "© Tina Monk, Chris Carrigan, Zygmunt Lozinksi, David Vines " .  $publish . ". ";
		$prefix = "You can use this " . $text_file . " if you abide by the terms of the ";
	} else if ( $romsey ) {
		echo "© Rüdiger Appel, Alexander, David Vines " . $publish . ". ";
		$prefix = "You can use this " . $text_file . " if you abide by the terms of the ";
	} else if ( $axiu ) {
		echo "© Axiu, David Vines " . $publish . ". ";
		$prefix = "You can use this " . $text_file . " if you abide by the terms of the ";
	}else {
		$prefix = "This " . $text_file . " is used under the terms of the ";
	}
	$licenseString = "This file is licensed under the ";
	$needspace = false;
	foreach ( $terms as $term ) {
		if ( $needspace ) { echo ' '; }
		if ( isset( $term->description ) && !(empty( $term->description ) ) ) {
			if ( substr( $term->description, 0, strlen( $licenseString ) ) === $licenseString ) {
				echo $prefix . substr( $term->description, strlen( $licenseString ));
			} else {
				echo $term->description ;
			}
		}
		$needspace = true;
	}
	echo "</dd>";
	if (has_term('', 'mediatag')) {
		echo "<dt>Tags</dt>";
		echo "<dd>";  the_terms( $post->ID, 'mediatag', '<span class="tags">', ' ', '</span>');
	}
}
?>
</dl>
