<?php
/**
 * @since caporil 3.226.0
**/

function caporil_enqueue_styles() {
 $parent_style = 'caporil-style';
 wp_enqueue_style( $parent_style, get_template_directory_uri().'/style.css', array(), '3.249.0');
 if ( !is_singular() || is_page_template( 'chronicle-page.php') ) {
 	wp_enqueue_style( 'chronicle-page-template', get_stylesheet_directory_uri() . '/chronicle.css', array(), wp_get_theme()->get('Version') );
 }
 if ( !is_singular() || is_page_template( array( 'en-garde-character-page.php', 'en-garde-news.php', 'en-garde-page.php' ) ) ) {
 	wp_enqueue_style( 'en-garde-page-template', get_stylesheet_directory_uri() . '/engarde.css', array(), wp_get_theme()->get('Version') );
 }
 if ( !is_singular() || is_page_template( array( 'liftoff-page.php', 'liftoff-news.php', 'liftoff-win.php' ) ) ) {
 	wp_enqueue_style( 'liftoff-page-template', get_stylesheet_directory_uri() . '/liftoff.css', array(), wp_get_theme()->get('Version') );
 }
 if ( !is_singular() || is_page_template( array( 'domainofancients-page.php', 'domainofancients-wider-page.php' ) ) ) {
 	wp_enqueue_style( 'domainofancientspage-template', get_stylesheet_directory_uri() . '/domainofancients.css', array(), wp_get_theme()->get('Version') );
 }
}
add_action( 'wp_enqueue_scripts', 'caporil_enqueue_styles' );

function caporil_setup() {

	/*
	 * Make Twenty Fourteen available for translation.
	 *
	 * Translations can be added to the /languages/ directory.
	 * If you're building a theme based on Twenty Fourteen, use a find and
	 * replace to change 'twentyfourteen' to the name of your theme in all
	 * template files.
	 */

	load_theme_textdomain( 'caporil', get_template_directory() . '/languages' );

	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'automatic-feed-links' );

	register_nav_menus( array(
			'primary'  => __( 'Primary Navigation', 'caporil'),
	) );

	/* Add title support */
	add_theme_support( 'title-tag' );

	/* Add our custom navigation menus */
	register_nav_menus( array(
			'liftoff'  => __( 'Liftoff! Navigation', 'caporil'),
			'en-garde' => __( 'En Garde Navigation', 'caporil')
	) );
}
add_action( 'after_setup_theme', 'caporil_setup' );

/**
 * Display navigation to next/previous set of posts when applicable.
 *
 * @since caporil 1.0.0
 *
 * @return void
 */
function caporil_paging_nav() {
	// Don't print empty markup if there's only one page.
	if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
		return;
	}

	$paged			= get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
	$pagenum_link	= html_entity_decode( get_pagenum_link() );
	$query_args		= array();
	$url_parts		= explode( '?', $pagenum_link );

	if ( isset( $url_parts[1] ) ) {
		wp_parse_str( $url_parts[1], $query_args );
	}

	$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
	$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

	$format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	$format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

	// Set up paginated links.
	$links = paginate_links( array(
		'base'		=> $pagenum_link,
		'format'	=> $format,
		'total'		=> $GLOBALS['wp_query']->max_num_pages,
		'current'	=> $paged,
		'mid_size'	=> 1,
		'add_args'	=> array_map( 'urlencode', $query_args ),
		'prev_text'	=> __( '&larr; Previous', 'caporil' ),
		'next_text'	=> __( 'Next &rarr;', 'caporil' ),
	) );

	if ( $links ) :

	?>
		<nav class="page_navi pagination loop-pagination">
			<?php echo $links; ?>
		</nav>
	<?php
	endif;
}

function caporil_update_years() {
	$publish = (int)get_the_date( 'Y' );
	$modify = (int)get_the_modified_date( 'Y' );
	if ( isset( $GLOBALS['caporil_year_publish'] ) ) {
		if ( $publish < $GLOBALS['caporil_year_publish'] ) {
			$GLOBALS['caporil_year_publish'] = $publish;
		}
	} else {
		$GLOBALS['caporil_year_publish'] = $publish;
	}
	if ( isset( $GLOBALS['caporil_year_modify'] ) ) {
		if ( $modify > $GLOBALS['caporil_year_modify'] ) {
			$GLOBALS['caporil_year_modify'] = $modify;
		}
	} else {
		$GLOBALS['caporil_year_modify'] = $modify;
	}
}

function caporil_enqueue_scripts() {

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	wp_enqueue_script( 'caporil-script', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ), '3.249.0', true );
}
add_action( 'wp_enqueue_scripts', 'caporil_enqueue_scripts' );

function caporil_wp_title( $title, $sep ) {
	global $paged, $page;

	if ( is_feed() ) {
		return $title;
	}

	// Add the site name.
	$title .= get_bloginfo( 'name' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) ) {
		$title = "$title $sep $site_description";
	}

	// Add a page number if necessary.
	if ( $paged >= 2 || $page >= 2 ) {
		$title = "$title $sep " . sprintf( __( 'Page %s', 'caporil' ), max( $paged, $page ) );
	}

	return $title;
}
add_filter( 'wp_title', 'caporil_wp_title', 10, 2 );

function caporil_widgets_init() {

	register_sidebar( array(
		'name'			=> __( 'Left Sidebar', 'caporil' ),
		'id'			=> 'sidebar-left',
		'description'	=> __( 'Additional sidebar that appears on the left.', 'caporil' ),
		'before_widget'	=> '<li id="%1$s" class="widget-container %2$s">',
		'after_widget'	=> '</li>',
		'before_title'	=> '<span class="widgettitle">',
		'after_title'	=> '</span>',
	) );
	register_sidebar( array(
		'name'			=> __( 'Right Sidebar', 'caporil' ),
		'id'			=> 'sidebar-right',
		'description'	=> __( 'Main sidebar that appears on the right.', 'caporil' ),
		'before_widget'	=> '<li id="%1$s" class="widget-container %2$s">',
		'after_widget'	=> '</li>',
		'before_title'	=> '<span class="widgettitle">',
		'after_title'	=> '</span>',
	) );
	register_sidebar( array(
		'name'			=> __('404 Page', 'caporil'),
		'id'			=> '404-widgets',
		'description'	=> __( 'Widgets placed here will be shown on the 404 page.', 'caporil' ),
		'before_widget'	=> '<div class="et_pb_post">',
		'after_widget'	=> '</div>',
		'before_title'	=> '<span class="widgettitle">',
		'after_title'	=> '</span>',
	) );
}
add_action( 'widgets_init', 'caporil_widgets_init' );

// Disable texturize (smart quotes and a few other things)
add_filter( 'run_wptexturize', '__return_false' );
// Force a wp_texturize reset
$dummy = wptexturize("<p>",true);

function caporil_title_apply_shortcodes($title, $sep) {
 return do_shortcode($title);
}
add_filter('wp_title', 'caporil_title_apply_shortcodes', 10, 2);

function caporil_remove_comment_reply_link_if_static($reply_link_html, $args, $comment, $post) {
	$static = caporil_get_theme_option( 'static' );
	if ( $static == 'on' ) {
		$reply_link_html = '';
	}
	return $reply_link_html;
}
add_filter( 'comment_reply_link', 'caporil_remove_comment_reply_link_if_static', 10, 4);

function caporil_tag_cloud_args( $cloud_args ){
 $cloud_args['smallest'] = 8;
 $cloud_args['largest'] = 28;
 $cloud_args['unit'] = 'px';
 return $cloud_args;
}

add_filter('widget_tag_cloud_args', 'caporil_tag_cloud_args');

function caporil_register_my_taxes_mediatag() {

	/**
	 * Taxonomy: Media Tags.
	 */

	$labels = [
			"name" => __( "Media Tags", "custom-post-type-ui" ),
			"singular_name" => __( "Media Tag", "custom-post-type-ui" ),
	];


	$args = [
			"label" => __( "Media Tags", "custom-post-type-ui" ),
			"labels" => $labels,
			"public" => true,
			"publicly_queryable" => true,
			"hierarchical" => false,
			"show_ui" => true,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"query_var" => true,
			"rewrite" => [ 'slug' => 'mediatag', 'with_front' => true, ],
			"show_admin_column" => false,
			"show_in_rest" => true,
			"show_tagcloud" => false,
			"rest_base" => "mediatag",
			"rest_controller_class" => "WP_REST_Terms_Controller",
			"rest_namespace" => "wp/v2",
			"show_in_quick_edit" => false,
			"sort" => false,
			"show_in_graphql" => false,
	];
	register_taxonomy( "mediatag", [ "attachment" ], $args );
}
add_action( 'init', 'caporil_register_my_taxes_mediatag' );

/*
 * Functions to display the standard page layout
 */
function caporil_standard_author_part() { ?>
	<div class="infometa author">By <?php the_author(); ?></div><?php
}
function caporil_standard_time_part() { ?>
	<div class="infometa time">First published <?php the_time( get_option( 'date_format' ));
		if ( get_the_date() !== get_the_modified_date() ) { ?> (Last Modified <?php the_modified_date()?>)<?php } ?>
	</div><?php
}
function caporil_standard_comment_part() {
	if ( ( strval(get_comments_number()) !== '0' ) || (caporil_get_theme_option( 'static' ) !== "on" ) ): ?>
		<span class="seprator"> / </span>
		<div class="infometa cmts"><?php comments_popup_link(); ?></div>
	<?php endif;
}
function caporil_standard_article_heading() { ?>
	<h1 class="wp-caption entry-title"><?php the_title(); ?></h1><?php
}
function caporil_standard_loop_body( $show_info, $heading_callback ) { ?>
	<article class="post">
		<header><?php call_user_func( $heading_callback ); ?></header><?php
		if ( $show_info ) : ?>
			<footer class="info"><?php
				if ( is_single() ) {
					caporil_standard_author_part();
					?><span class="seprator"> / </span><?php
				}
				caporil_standard_time_part();
				caporil_standard_comment_part(); ?>
			</footer><?php
		endif; ?>
		<?php the_content(); ?>
	</article><div class="clear"></div><?php
}
function caporil_standard_page( $params = array() ) {
	// Save backtrace for debugging output later
	$backtrace = debug_backtrace();
	// Work out parameters and defaults
	if ( isset( $params['section_type'] ) ):
		$section_type = $params['section_type'];
	else:
		$section_type = 'archive';
	endif;
	if ( isset( $params['sidebar_count'] ) ):
		$number_of_sidebars = $params['sidebar_count'];
	else:
		$number_of_sidebars = 2;
	endif;
	if ( isset( $params['pane_class'] ) ):
		$pane_class = $params['pane_class'];
	else:
		$pane_class = '';
	endif;
	if ( array_key_exists( 'loop_callback', $params ) ):
		$loop_callback = $params['loop_callback'];
	else:
		$loop_callback = 'caporil_standard_loop_body';
	endif;
	if ( isset( $params['caption_callback'] ) ):
		$caption_callback = $params['caption_callback'];
	else:
		$caption_callback = null;
	endif;
	if ( array_key_exists( 'heading_callback', $params ) ):
		$heading_callback = $params['heading_callback'];
	else:
		$heading_callback = 'caporil_standard_article_heading';
	endif;
	if ( isset( $params['no_post_callback'] ) ):
		$no_post_callback = $params['no_post_callback'];
	else:
		$no_post_callback = null;
	endif;
	if ( isset( $params['hide_info'] ) ):
		$show_info = false;
	else:
		$show_info = true;
	endif;
	// Decide on the sidebar related classes
	switch( $number_of_sidebars ) {
		case 0:  $content_class = "nosidebars";      $left_sidebar_class = "closed touched"; $right_sidebar_class = "closed touched"; break;
		case 1:  $content_class = "onlyleftsidebar"; $left_sidebar_class = "open";   $right_sidebar_class = "closed touched"; break;
		default: $content_class = "twosidebars";     $left_sidebar_class = "open";   $right_sidebar_class = "open";   break;
	}
	?>
	<div id="content" class="<?php echo $content_class; ?>">
		<!-- Called from <?php echo $backtrace[0]['file']; ?> with <?php print_r($backtrace[0]['args'][0]); ?>-->
		<?php $classes = "section " . $section_type;
		if ($pane_class !== '') { $classes .= ' ' . $pane_class; } ?>
		<main class="<?php echo $classes; ?>">
			<?php if ( $caption_callback !== null) { call_user_func( $caption_callback ); }
			if ( $loop_callback !== null ) : ?>
				<?php if(have_posts()) :
					while(have_posts()) :
						the_post();
						caporil_update_years();
						call_user_func( $loop_callback, $show_info, $heading_callback );
					endwhile;
				else:
					if ( $no_post_callback !== null ) { call_user_func( $no_post_callback ); }
				endif;
				comments_template(); ?>
			<?php else:
				if ( $no_post_callback !== null ) { call_user_func( $no_post_callback ); }
			endif; ?>
			<?php caporil_paging_nav(); ?>
		</main>
		<aside id="leftsidebar"  class="sidebar"><?php get_sidebar('left'); ?></aside>
		<aside id="rightsidebar" class="sidebar"><?php get_sidebar();       ?></aside>
		<div id="leftsidebartoggle"  class="left  sidebartoggle <?php echo $left_sidebar_class;  ?>"></div>
		<div id="rightsidebartoggle" class="right sidebartoggle <?php echo $right_sidebar_class; ?>"></div>
	</div><?php
}
/* --------------------- Functions for updating themes ------------------------------ */
function caporil_get_remote_update_from( $sitebase, $uploads, $slug ) {
	$url = $uploads . '/jsons/' . $slug . '.json';
	$remote =  wp_remote_get( $url, array( 'timeout' => 10, 'headers' => array( 'Accept' => 'application/json' ) ) );
	if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
		$remote['uploads'] = $uploads;
		$remote['sitebase'] = $sitebase;
	}
	return $remote;
}
function caporil_get_remote_update_info( $slug ) {
	$remote = get_transient( 'djv_update_' . $slug );
	if (false == $remote || is_wp_error($remote) || !isset( $remote['response']['code'] ) || 200 !== $remote['response']['code'] || empty( $remote['body'] ) ) {
		$sitebase = get_site_url( );
		$upload_dir = wp_upload_dir( );
		if ( is_ssl() ) { $upload_dir['baseurl'] = str_replace( 'http://', 'https://', $upload_dir['baseurl'] ); }
		$remote = caporil_get_remote_update_from( $sitebase, $upload_dir['baseurl'], $slug );
		if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
			set_transient( 'djv_update_' . $slug, $remote, 10 ); // Save for only 10 seconds here
		} else {
			$remote = caporil_get_remote_update_from( 'https://blog.tremlas.com', 'https://blog.tremlas.com/wp-content/uploads', $slug );
			if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
				set_transient( 'djv_update_' . $slug, $remote, 43200 ); // Save for 12 hours
			}
		}
	}
	if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
		$body = json_decode( $remote['body'] );
		$changelog = $body->sections->changelog;
		$changelog = str_replace( '<a href="', '<a href="' . $remote['uploads'] . '/' , $changelog );
		$info = array(
				'name'			=> 'caporil',
				'slug'			=> $slug,
				'version'		=> $body->version,
				'requires'		=> $body->requires,
				'author'		=> '<a href="' . $body->author_profile . '">' . $body->author . '</a>',
				'download_link'	=> $remote['uploads'] . '/' . $body->download_url,
				'trunk'			=> $remote['uploads'] . '/' . $body->download_url,
				'last_updated'	=> $body->last_updated,
				'sections'		=> array(
						'description'	=> implode( "\n", $body->sections->description ),
						'installation'	=> implode( "\n", $body->sections->installation ),
						'changelog'		=> implode( "\n", $changelog ),
				),
				'homepage'		=> $remote['sitebase'] . '/' . $body->homepage
		);
		return $info;
	}
	return false;
}

function caporil_check_for_update( $slug ) {
	$info = caporil_get_remote_update_info( $slug );
	if ( false == $info ) {
		return false;
	}
	if ( version_compare( '3.249.0', $info['version'], '<' ) && version_compare( $info['requires'], get_bloginfo( 'version' ), '<' ) ) {
		$update = array(
				'slug'			=> $slug,
				'new_version'	=> $info['version'],
				'url'			=> $info['homepage'],
				'package'		=> $info['download_link'],
				'icons'			=> array(),
				'banners'		=> array(),
				'banners_rtl'	=> array(),
				'tested'		=> '',
				'requires_php'	=> '',
				'compatability'	=> new StdClass()
		);
		return $update;
	} else {
		return false;
	}
}

function caporil_pre_set_site_transient_update_themes( $transient ) {
	// Check for update
	$themeslug = 'caporil';
	$update = caporil_check_for_update( $themeslug );
	if ( $update ) {
		$transient->response[$themeslug] = $update;
	} else {
		// No update is available.
		$item = array(
		'theme'        => 'my-theme',
		'new_version'  => '3.249.0',
		'url'          => '',
		'package'      => '',
		'requires'     => '',
		'requires_php' => '',
		);
		// Adding the "mock" item to the `no_update` property is required
		// for the enable/disable auto-updates links to correctly appear in UI.
		$transient->no_update[$themeslug] = $item;
	}
	return $transient;
}
add_filter( 'pre_set_site_transient_update_themes', 'caporil_pre_set_site_transient_update_themes' );

function caporil_theme_info( $result, $action, $args ) {
	$slug = 'caporil';
	if ( 'plugin_information' !== $action ) {
		return $result;
	}
	if ( $slug !== $args->slug) {
		return $result;
	}
	return caporil_get_remote_update_info( $slug );
}
add_filter( 'themes_api', 'caporil_theme_info', 10, 3 );

/* ------------------------------ And load in the options ----------------------- */
require_once( __DIR__ . '/options.php');

?>