<?php
/**
 * Template Name: Chronicle Page
 * @since caporil 3.226.0
 **/
get_header ();

function caporil_chronicle_loop_callback( $show_info, $heading_callback ) {
	global $post;
	$pagelist = get_pages("child_of=".$post->post_parent."&parent=".$post->post_parent."&sort_column=menu_order&sort_order=asc");
	$pages = array();
	foreach ($pagelist as $page) {
		$pages[] += $page->ID;
	}

	$current = array_search($post->ID, $pages);
	if (array_key_exists( $current-1, $pages)) { $prevID = $pages[$current-1]; }
	if (array_key_exists( $current+1, $pages)) { $nextID = $pages[$current+1]; }?>
	<article class="post">
		<?php the_content(); ?>
		<div class="clear"></div>
		<div class="chronicle-navigation">
			<hr><?php if (!empty($prevID)) { ?>
				<div class="previous">
					<a href="<?php echo get_permalink($prevID); ?>" title="<?php echo get_the_title($prevID); ?>">&lt; <?php echo get_the_title($prevID); ?></a>
				</div>
			<?php } ?>
			<?php if (!empty($nextID)) { ?>
				<div class="next">
					<a href="<?php echo get_permalink($nextID); ?>" title="<?php echo get_the_title($nextID); ?>"><?php echo get_the_title($nextID); ?> &gt;</a>
				</div>
			<?php } ?>
		</div>
	</article><?php
}

caporil_standard_page( array(  'section_type' => 'single post', 'loop_callback' => 'caporil_chronicle_loop_callback' ) );

get_footer();
?>
