<?php
/**
 * @since caporil 3.226.0
**/
get_header();

function caporil_attachment_loop_body() {
	global $post; ?>
	<article class="post">
		<h1 class="entry-title"><?php the_title(); ?></h1>
		<div class="infometa author">
			<?php the_time( get_option( 'date_format' )); ?>
			<?php if ( caporil_get_theme_option( 'static' ) != "on" ) : ?>
				<span class="seprator">/</span>
				<?php comments_popup_link(); ?>
			<?php endif; ?>
		</div>
		<?php $mimetype = get_post_mime_type( $post->ID ); ?>
		<?php $main_mimetype = strtok( $mimetype, '/' ); ?>
		<div class="download">
			<?php if ( $main_mimetype === 'image' ): ?>
				<?php $attLink = wp_get_attachment_link( $post->ID, 'full' );
				$imageActualFile = get_attached_file($post->ID);
				$imageOriginalFile = wp_get_original_image_path($post->ID);
				if ( strcmp( $imageActualFile, $imageOriginalFile ) ) {
					echo str_replace( basename($imageActualFile), basename($imageOriginalFile), $attLink );
					$imageScaled = true;
				} else {
					echo $attLink;
					$imageScaled = false;
				}
				$text_File = 'Image'; $text_file = 'image';  $imageMeta = wp_get_attachment_metadata($post->ID); ?>
			<?php elseif ( $main_mimetype === 'video' ): ?>
				<?php echo do_shortcode( '[video mp4=' . wp_get_attachment_url( $post->ID ) . ']' ); ?>
				<?php $text_File = 'Video'; $text_file = 'video'; ?>
			<?php elseif ( $mimetype === 'application/zip' ): ?>
				<a class="nobar" href="<?php echo wp_get_attachment_url( $post->ID ); ?>">
				<img src="<?php echo get_stylesheet_directory_uri(); ?>/icons/zip-svgrepo-com.png" loading="lazy" width="256" height="256"/>
				<br><div class="textlink"><p><span><?php the_title(); ?></span></div>
				</a>
				<?php $text_File = 'Zip File'; $text_file = 'zip file'; ?>
			<?php else: ?>
				<?php $atturl = wp_get_attachment_url( $post->ID ); $filetype = wp_check_filetype( $atturl ); ?>
				<?php if ( $filetype['ext'] === false ) { $filetypeext = substr( $atturl, strrpos( $atturl, '.' ) + 1 ); } else { $filetypeext = $filetype['ext']; }?>
				<a class="nobar" href="<?php echo wp_get_attachment_url( $post->ID ); ?>">
				<img src="<?php echo get_stylesheet_directory_uri(); ?>/icons/<?php echo $filetypeext; ?>.png" loading="lazy" width="64" height="64"/>
				<br><div class="textlink"><p><span><?php the_title(); ?></span></div>
				</a>
				<?php $text_File = 'File'; $text_file = 'file'; ?>
			<?php endif; ?>
		</div>
		<?php include get_theme_file_path( '/includes/metadata.php' );?>
	</article><?php
}

caporil_standard_page( array('section_type' => 'single post', 'loop_callback' => 'caporil_attachment_loop_body' ) );

get_footer(); ?>