<?php
/*
 Plugin Name: Romsey Signal Box Simulation
 Plugin URI: https://blog.tremlas.com/wordpress-plugins/romsey-signal-box-simulation-plugin-details/
 Description: Adds a Simulation of Romsey Signal Box as a shortcode
 Version: 3.244.0
 Author: David Vines
 Author URI: http://tremlas.com
 License:  BSD 3 Clause
 License URI: https://opensource.org/licenses/BSD-3-Clause
 */
/* © Copyright 2020, 2021 David Vines
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
 *    in the documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

include_once 'common.php';

/**
 * Shortcode to add the version of the plugin
 */
function djv_romseySignalBoxVersion_shortcode() {
	return 'Romsey Signal Box Simulation Version 3.244.0';
}
add_shortcode( 'romseySignalBoxVersion', 'djv_romseySignalBoxVersion_shortcode' );

/**
 * Shortcode to add a simulation of Romsey Signal Box
 */

// Now for a shortcode that can be used to get links and/or tables for the characters
function djv_romseySignalBox_shortcode( $attr, $content = null ) {

	$plugin_url = plugin_dir_url(__FILE__);
	wp_enqueue_script('segment_display_js',        $plugin_url.'js/segment-display.js', array(), '3.244.0', true );
	wp_enqueue_script('djv_romsey_utils_js',       $plugin_url.'js/utils.js', array(), '3.244.0', true );
	wp_enqueue_script('djv_romsey_bellcode_js',    $plugin_url.'js/bellcode.js', array(), '3.244.0', true );
	wp_enqueue_script('djv_romsey_scheduler_js',   $plugin_url.'js/scheduler.js', array('djv_romsey_utils_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_bell_js',        $plugin_url.'js/bell.js', array('djv_romsey_scheduler_js','djv_romsey_bellcode_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_model_js',       $plugin_url.'js/model.js', array('djv_romsey_utils_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_view_js',        $plugin_url.'js/view.js', array('djv_romsey_utils_js','djv_romsey_model_js','segment_display_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_signalbox_js',   $plugin_url.'js/signalbox.js', array('djv_romsey_utils_js','djv_romsey_bellcode_js','djv_romsey_model_js','segment_display_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_singlesignalbox_js',   $plugin_url.'js/singlesignalbox.js', array('djv_romsey_utils_js','djv_romsey_bellcode_js','djv_romsey_model_js','djv_romsey_signalbox_js'), '3.244.0',true );
	wp_enqueue_script('djv_romsey_doublesignalbox_js',   $plugin_url.'js/doublesignalbox.js', array('djv_romsey_utils_js','djv_romsey_bellcode_js','djv_romsey_model_js','djv_romsey_signalbox_js'), '3.244.0',true );
	wp_enqueue_script('djv_romsey_trainaction_js', $plugin_url.'js/trainaction.js', array('djv_romsey_singlesignalbox_js','djv_romsey_doublesignalbox_js','djv_romsey_utils_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_train_js',       $plugin_url.'js/train.js', array('djv_romsey_trainaction_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_trains_js',      $plugin_url.'js/trains.js', array('djv_romsey_utils_js','djv_romsey_train_js','djv_romsey_bellcode_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_clock_js',       $plugin_url.'js/clock.js', array('djv_romsey_scheduler_js','djv_romsey_view_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_message_js',     $plugin_url.'js/message.js', array('djv_romsey_clock_js','djv_romsey_utils_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_controller_js',  $plugin_url.'js/controller.js', array('djv_romsey_utils_js','djv_romsey_scheduler_js','djv_romsey_bell_js','djv_romsey_singlesignalbox_js','djv_romsey_singlesignalbox_js','djv_romsey_trains_js','djv_romsey_clock_js','djv_romsey_model_js','djv_romsey_view_js','djv_romsey_message_js'), '3.244.0', true );
	wp_enqueue_script('djv_romsey_js',             $plugin_url.'js/romsey.js', array('djv_romsey_controller_js','djv_romsey_utils_js'), '3.244.0', true );

	wp_enqueue_style('djv_romsey_css', $plugin_url.'css/romsey.css');

	static $id = 0; $id++;

	$text  = '' . PHP_EOL;

	$file = plugin_dir_path(__FILE__);
	if ( !empty( $content ) ) {
		$content = do_shortcode( $content );
	} else {
		$content = 'Romsey Signal Box Simulation Version 3.244.0';
	}

	$filecontent = file_get_contents($file.'/html/romsey.html');
	$filecontent = str_replace('@@@ID@@@', $id, $filecontent );
	$filecontent = str_replace('@@@PLUGIN@@@', $plugin_url, $filecontent );
	$filecontent = str_replace('@@@CONTENT@@@', $content, $filecontent );

	$text .= $filecontent . PHP_EOL;

	$text .= '<script type="text/javascript">' . PHP_EOL;
	$text .= 'var options = options || {};' . PHP_EOL;
	$text .= 'options.ids = options.ids || [];' . PHP_EOL;
	$text .= 'options.ids.push(' . $id . ');' . PHP_EOL;
	$text .= '</script>' . PHP_EOL;

	return $text;
}

add_shortcode( 'romseySignalBox', 'djv_romseySignalBox_shortcode' );

/* --------------------- Functions for updating plugins ------------------------------ */
function djv_romseySignalBox_pre_set_site_transient_update_plugins( $transient ) {
 $id = 'RomseySignalBox/RomseySignalBox.php';
 $name = 'Romsey Signal Box Simulation';
 $slug = 'RomseySignalBox';
 return djv_plugin_pre_set_site_transient( $transient, $id, $name, $slug, '3.244.0' );
}
add_filter( 'pre_set_site_transient_update_plugins', 'djv_romseySignalBox_pre_set_site_transient_update_plugins' );

function djv_romseySignalBox_plugin_info( $result, $action, $args ) {
	$name = 'Romsey Signal Box Simulation';
	$slug = 'RomseySignalBox';
	if ( 'plugin_information' !== $action ) {
		return $result;
	}
	if ( $slug !== $args->slug) {
		return $result;
	}
	return djv_plugin_get_remote_update_info( $name, $slug );
}
add_filter( 'plugins_api', 'djv_romseySignalBox_plugin_info', 10, 3 );

?>