/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* globals exports, module */
/* exported Tech, TECHS, ALLTECHS */
var ALLTECHS = [];
class Tech {
	constructor(domprefix,option,levels) {
		this._domprefix = domprefix;
		this._option = option;
		this._index = ALLTECHS.length;
		this._levels = [...levels];
		ALLTECHS.push(this);
	}
	level(points) {
		let l = 1; // Default level is 1
		for(let i=0; i<this._levels.length; i++)
		{
			if (points >= this._levels[i]) {
				l = i+2; // Zeroth entry is the level needed for TL2
			}
		}
		return l;
	}
	moreResearchAvailable(points) {
		return points < this._levels[this._levels.length-1];
	}
	pointsToNextLevel(points) {
		const nextLevelIndex = this.level(points)-1; // Zeroth entry is the level needed for TL2
		return this._levels[nextLevelIndex] - points;
	}
	get domPrefix() { return this._domprefix; }
	get option() { return this._option; }
	get index() { return this._index; }
}
// The order here needs to match that in expenditure.html (so that computer and human players are using the same indexes)
var TECHS = {
	powerPlant:        new Tech("powerPlant",       "Power Plant",        [270,1520,4000,6250,10000,19900]),
	jumpDrive:         new Tech("jumpDrive",        "Jump Drive",         [240,1240,2700,4750,7000,11000,15000]),
	maneuverDrive:     new Tech("maneuverDrive",    "Maneuver Drive",     [240,1240,2700,4750,7000,11000,15000]),
	communications:    new Tech("communications",   "Communications",     [240,800,1700,3650,6450,10000,15500]),
	shipSize:          new Tech("shipSize",         "Ship Size",          [240,800,1800,4000,8000,13700,20000,30000]),
	planetaryDefences: new Tech("planetaryDefence", "Planetary Defences", [240,960,2150,5000,10000,16000,20000]),
	weaponary:         new Tech("weaponary",        "Ship Weaponary",     [240,960,2150,5000,7000,10000,12500,16000,20000,25000]),
	computers:         new Tech("computers",        "Computers",          [240,800,1600,3200,6000,9000,12500,20000]),
	shipDefences:      new Tech("shipDefences",     "Ship Defences",      [240,1600,2500,4000,6000,8000,12000]),
	archaeology:       new Tech("archaeology",      "Archaeology",        [400,1600,4000,7500,10000])
};

//For testing via QUnit
if (typeof module !== "undefined" && module.exports) {
	exports.ALLTECHS = ALLTECHS;
	exports.TECHS = TECHS;
	exports.Tech = Tech;
}