/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* globals TECHS, ShipOrder, ShipDesignType, ShipDesigner, VesselOrderMaker */
/* exported ShipOrderReport */
let ShipOrderReport = {
	init: function() {
		ShipOrderReport._vesselOrderMaker = new VesselOrderMaker();
	},
	showShipReports: function(player,baseMap) {
		const selfReport = ShipOrderReport;
		if (player.researchLevel(TECHS.planetaryDefences) >= 3) {
			document.getElementById("spaceBasesDiv").classList.remove("hidden");
			if (player.researchLevel(TECHS.planetaryDefences) >= 4) {
				document.getElementById("starBasesDiv").classList.remove("hidden");
			}
		}
		let ships = document.getElementById("ships");
		let spaceBases = document.getElementById("spaceBases");
		let starBases = document.getElementById("starBases");
		// Delete all rows after the template
		for(let table of [ships,spaceBases,starBases]) {
			let templaterow = table.querySelector(".template.last");
			while (templaterow.nextSibling) {
				templaterow.parentNode.removeChild(templaterow.nextSibling);
			}
		}

		for(let ship of player.ships) {
			const newrow = (ship.design.type == ShipDesignType.Ship ? ships : (ship.design.type == ShipDesignType.SpaceBase ? spaceBases : starBases)).insertRow();
			const namecell = document.createElement("td"); namecell.append(ship.name);
			namecell.append(document.createElement("br"));
			const designbutton = document.createElement("button");
			designbutton.append("Review design");
			const selfShip = ship;
			designbutton.onclick = function() { ShipDesigner.review("summary",selfShip); };
			namecell.append(designbutton);
			const loccell = document.createElement("td"); loccell.append(ship.location);
			const repcell = document.createElement("td"); repcell.append(ship.report ? ship.report : "Nothing to report");
			if (ship.getColonyImprovement()) {
				repcell.append(document.createElement("br"));
				repcell.append(`Can improve a colony's class by ${ship.getColonyImprovement()}`);
			}
			if (ship.getMaxMarines()) {
				repcell.append(document.createElement("br"));
				repcell.append(`${ship.marines} of ${ship.getMaxMarines()} marine${ship.getMaxMarines()==1?"":"s"} on board`);
			}
			if (ship.getRepairCost()) {
				const bold = document.createElement("b"); bold.append("Blocks needing repair: ");
				const damaged = ship.getDestroyedBlocks();
				let comma = "";
				if (damaged.length > 0) {// It could be zero if all that needs 'repair' is destroyed fighters
					let previous = damaged[0].name, count = 1;
					for(let i=1; i<damaged.length; i++) {
						if (previous == damaged[i].name) {
							count++;
						} else {
							if (count==1) {
								bold.append(comma+previous);
							} else {
								bold.append(comma+count+"x"+previous);
							}
							comma = ", ";
							previous = damaged[i].name;
							count = 1;
						}
					}
					if (count==1) {
						bold.append(comma+previous);
					} else {
						bold.append(comma+count+"x"+previous);
					}
					comma = ", ";
				}
				const missingFighters = ship.getMaxFighters()-ship.getFighterCount();
				if (missingFighters > 0) {
					if (comma) bold.append(comma);
					bold.append(`${missingFighters} Fighter${missingFighters==1?"":"s"} need ${missingFighters==1?"s":""} replacing`);
				}
				repcell.append(document.createElement("br"));
				repcell.append(bold);
			}
			if (ship.getMaxDredgers() > 0) {
				let dredgerReport = null;
				if (baseMap.hex(ship.location).planet) {
					dredgerReport = "Unable to dredge Jump Space as there is a planet in this hex";
				} else if (ship.nonDredgerUnits) {
					dredgerReport = "Unable to dredge Jump Space as a ship without jump space dredgers entered (or remained) in this hex";
				} else if (ship.getDredgers() == 0) {
					dredgerReport = "Unable to dredge Jump Space as all dredgers on the ship are damaged or destroyed";
				} else if (ship.unjumpedTurns == 0 && ship.design.type == ShipDesignType.StarBase) {
					dredgerReport = "Unable to dredge Jump Space as this star base has only just been constructed";
				} else if (ship.unjumpedTurns == 0) {
					dredgerReport = "Unable to dredge Jump Space as this ship jumped in the last turn";
				} else {
					const dredge = ship.unjumpedTurns*ship.getDredgers();
					dredgerReport = `Dredged Jump Space for ${dredge} PP${dredge==1?"":"s"} this turn`;
				}
				repcell.append(document.createElement("br"));
				repcell.append(dredgerReport);
			}
			ship.order = new ShipOrder(ship.retreatingTo);
			const ordercell = document.createElement("td");
			const changecell = document.createElement("td");
			const changebutton = document.createElement("button");
			changebutton.append("Change Orders...");
			const selfPlayer = player;
			const callback = function() {
				ordercell.replaceChildren();
				if (selfShip.retreatingTo) {
					ordercell.append("Retreating to "+selfShip.retreatingTo);
				} else {
					ordercell.append(selfShip.order.toString());
				}
			};
			changebutton.onclick = function() {
				selfReport._vesselOrderMaker.open(selfPlayer,selfShip,callback);
			};
			callback();
			changecell.append(changebutton);
			newrow.append(namecell,loccell,repcell,ordercell,changecell);
		}
	},
};