/*!
 * © 2022 David Vines
 *
 * domainOfTheAncients is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * domainOfTheAncients is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
 */
/* global module, exports, */
/* exported ShipOrder, RepairShipOrder, ScrapShipOrder */
class ShipOrder {
	constructor(jump,colonise) {
		jump = jump || null;
		colonise = colonise || false;
		this._jump = jump;
		this._colonise = colonise;
		this._busting = false;
		this._retreating = false;
		this._marines = null;
	}
	get jump() { return this._jump; }
	set jump(jump) { this._jump = jump; }
	cancelJump() { this._jump = null; }
	get colonise() { return this._colonise; }
	set colonise(colonise) { this._colonise = colonise; }
	get bust() { return this._busting; }
	set bust(busting) { this._busting = busting; }
	get retreating() { return this._retreating; }
	set retreating(retreating) { this._retreating = retreating; }
	get marinesEmbarking() {
		return this._marines == "e";
	}
	get marinesDisembarking() {
		return this._marines == "d";
	}
	setMarinesToEmbark() {
		this._marines = "e";
	}
	setMarinesToDisembark() {
		this._marines = "d";
	}
	resetMarines() {
		this._marines = null;
	}
	toJSON() {
		let data = {};
		if (this._jump) { data.jump = this._jump; }
		if (this._colonise) { data.colonise = true; }
		if (this._busting) { data.busting = true; }
		if (this._retreating) { data.retreating = true; }
		if (this._marines) { data.marines = this._marines; }
		return data;
	}
	toString() {
		let result = "Hold Postion";
		if (this._jump && this._retreating) { result = "Retreating to "+this._jump; }
		if (this._jump && !this._retreating) { result = "Jump to "+this._jump; }
		if (!this._jump && this._retreating) { result = "Return from jump space after retreating"; }
		if (this._colonise) { result += " and colonise"; }
		if (this._busting) { result += "and use a planet buster on any planet"; }
		if (this._marines == "e") { result += " and embark marines"; }
		if (this._marines == "d") { result += " and disembark marines"; }
		return result;
	}
}

class RepairShipOrder extends ShipOrder{
	constructor(value) {
		super();
		this._value = value;
	}
	get value() { return this._value; }
	toJSON() {
		return {type: "RSO", value: this._value};
	}
	toString() {
		return "Repair the ship costing "+this._value+" PPs";
	}
}

class ScrapShipOrder extends ShipOrder {
	constructor(value) {
		super();
		this._value = value;
	}
	toJSON() {
		return {type: "SSO", value: this._value};
	}
	toString() {
		return "Scrap this ship for "+this._value+" PPs";
	}
}

ShipOrder.fromJSON = function(json) {
	if (json.type) {
		if (json.type == "RSO") return new RepairShipOrder(json.value);
		if (json.type == "SSO") return new ScrapShipOrder(json.value);
		return null;
	} else {
		// Standard ShipOrder
		json.jump = json.jump || null;
		json.colonise = json.colonise || false;
		let order = new ShipOrder(json.jump,json.colonise);
		order._busting = json.busting || false;
		order._retreating = json.retreating || false;
		order._marines = json.marines || null;
		return order;
	}
};

//For testing via QUnit
if (typeof module !== "undefined" && module.exports) {
    exports.ShipOrder = ShipOrder;
}