//
// © Copyright 2020 David Vines
//
// Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
//    in the documentation and/or other materials provided with the distribution.
// 
// 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived 
//    from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
// COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
/* globals Capture */
function RomseyMessageBox(clock,id) {
    this._clock = clock;
    this._id = id;
    this._div = document.getElementById("djvRomseySignalBox-"+this._id+"-message");
    this._from = document.getElementById("djvRomseySignalBox-"+this._id+"-message-from");
    this._text = document.getElementById("djvRomseySignalBox-"+this._id+"-message-text");
    this._button = document.getElementById("djvRomseySignalBox-"+this._id+"-message-button");
    this._footnote = document.getElementById("djvRomseySignalBox-"+this._id+"-message-footnote");
}

RomseyMessageBox.prototype = {
    showMessage: function(from,message,footnote) {
        this._clock.pause();
        this._div.classList.remove("hide");
        this._from.textContent = from;
        this._text.textContent = message;
        this._footnote.textContent = (footnote ? footnote : ""); 
        this._button.onclick = this.safely(this.acknowledge());
    },
    safely: function(f) {
        const self = this;
        return function() {
            Capture.exception(self._id, f, self);
        };
    },
    acknowledge: function() {
        const self = this;
        return function() {
            self._div.classList.add("hide");
            self._clock.unpause();
            self._button.onclick = null;
        };
    }
};