//
// © Copyright 2020 David Vines
//
// Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
//    in the documentation and/or other materials provided with the distribution.
// 
// 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived 
//    from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
// COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
/* globals Invocation */
function Clock(scheduler,view) {
    this._scheduler = scheduler;
    this._view = view;
    this._ticks = 0;
    this._nextTick = null;
    this._tickInvocation = new Invocation(this.tickClock,this);
    this._view.renderClock(this.tickClock,this);
    this.setClock(12,0,0);
}
Clock.prototype = {
    scheduleTick: function() {
        this._nextTick = this._scheduler.addRealTimeEvent(1/this._scheduler.getWarpFactor(),this._tickInvocation);
    },
    setWarpFactor: function(factor) {
        if (this._nextTick) {
            this._nextTick.cancel();
            this._nextTick = null;
        }
        if (factor === 0) {
            this._scheduler.pause();
        } else {
            this._scheduler.setWarpFactor(factor);
            this._scheduler.unpause();
            this.scheduleTick();
        }
    },
    pause: function() {
        this._scheduler.pause();
    },
    unpause: function() {
        this._scheduler.unpause();
    },
    tickClock: function() {
        this._ticks++;
        this._ss++;
        if (this._ss === 60) {
            this._ss = 0;
            this._mm++;
            if (this._mm === 60) {
                this._mm = 0;
                this._hh++;
                if (this._hh === 24) {
                    this._hh = 0;
                }
            }
        }
        this._view.updateClock(this.getClockAsString());
        this.scheduleTick();
    },
    getTicks: function() {
        return this._ticks;
    },
    getHh: function() { return this._hh; },
    getMm: function() { return this._mm; },
    getSs: function() { return this._ss; },
    getClockAsString: function() {
        return this.getClockAsStringAfterXMilliseconds(0);
    },
    setClock: function(hh,mm,ss) {
        this._hh = hh;
        this._mm = mm;
        this._ss = ss;
        this._view.updateClock(this.getClockAsString());
    },
    getClockAsStringAfterXMilliseconds: function(millis) {
        var ss = this._ss + Math.floor(millis/1000);
        var mm = this._mm;
        var hh = this._hh;
        
        mm += Math.floor(ss/60); ss %= 60;
        hh += Math.floor(mm/60); mm %= 60;
        hh %= 24;
        return (((hh < 10) ? '0' : '')+hh+":"+((mm < 10) ? '0' : '')+mm+":"+((ss < 10) ? '0' : '')+ss);
    }
};