<?php
/*
Plugin Name: Domain Of The Ancients
Plugin URI: https://blog.tremlas.com/wordpress-plugins/domain-of-the-ancients-plugin-details/
Description: Adds a shortcode that inserts the Domain Of The Ancients game
Version: 3.218.0
Author: David Vines
Author URI: http://tremlas.com
License: GPLv2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/
/* © Copyright 2022 David Vines

domainOfTheAncients is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

domainOfTheAncients is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with domainOfTheAncients. If not, see https://www.gnu.org/licenses/gpl-2.0.html.
*/
include_once 'common.php';

/**
 * Shortcode to add the version of the plugin
 */
function djv_domainOfTheAncients_domainOfTheAncientsVersion_shortcode() {
	return 'Domain Of The Ancients Version 3.218.0';
}
add_shortcode( 'domainOfTheAncientsVersion', 'djv_domainOfTheAncients_domainOfTheAncientsVersion_shortcode' );

/**
 * Add the "Domain Of The Ancients" game. Only one per page is supported.
 */

// Now for a shortcode that can be used to get links and/or tables for the characters
function djv_domainOfTheAncients_shortcode( $attr, $content = null ) {
	// dependencies show initialisation dependencies
	$plugin_url = plugin_dir_url(__FILE__);
	wp_enqueue_script('djv_domainOfTheAncients_exceptionbox', $plugin_url.'js/util/exceptionbox.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_modaldialog', $plugin_url.'js/util/modaldialog.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_rangedcombo', $plugin_url.'js/util/rangedcombo.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_rot',    $plugin_url.'js/rot/rot.min.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_ship',   $plugin_url.'js/domainOfTheAncients/ship.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_shipdesign', $plugin_url.'js/domainOfTheAncients/shipdesign.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_shipdesigner', $plugin_url.'js/domainOfTheAncients/shipdesigner.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_util',   $plugin_url.'js/domainOfTheAncients/util.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_tech',   $plugin_url.'js/domainOfTheAncients/tech.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_map',    $plugin_url.'js/domainOfTheAncients/map.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_player', $plugin_url.'js/domainOfTheAncients/player.js', array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_order',  $plugin_url.'js/domainOfTheAncients/order.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_playerresearch', $plugin_url.'js/domainOfTheAncients/playerresearch.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_buildvessel', $plugin_url.'js/domainOfTheAncients/buildvessel.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_playerorders', $plugin_url.'js/domainOfTheAncients/playerorders.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_shiporder', $plugin_url.'js/domainOfTheAncients/shiporder.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_vesselordermaker', $plugin_url.'js/domainOfTheAncients/vesselordermaker.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_shiporderreport', $plugin_url.'js/domainOfTheAncients/shiporderreport.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_computer', $plugin_url.'js/domainOfTheAncients/computer.js',  array(), '3.218.0' );
	wp_enqueue_script('djv_domainOfTheAncients_turn',   $plugin_url.'js/domainOfTheAncients/turn.js',  array(), '3.218.0' );

	// The game requires the custom elements to have been defined before it can init - hence the dependencies listed here
	wp_enqueue_script('djv_domainOfTheAncients_game',   $plugin_url.'js/domainOfTheAncients/game.js',  array('djv_domainOfTheAncients_exceptionbox', 'djv_domainOfTheAncients_modaldialog'), '3.218.0' );

	wp_enqueue_style('djv_domainOfTheAncientsStyle', $plugin_url.'css/domainOfTheAncients.css', array(), '3.218.0' );

	$file = plugin_dir_path(__FILE__);
	$filecontent = file_get_contents($file.'/html/domainOfTheAncients.html');

	// Resolve includes
	$offset = 0;
	while( $start = strpos( $filecontent, '@@include(\'', $offset ) ) {
		$end = strpos($filecontent, '\')', $start );
		$left = substr( $filecontent, 0, $start);
		$filename = substr( $filecontent, $start+11, $end-$start-11);
		$right = substr($filecontent, $end+2);

		if ( file_exists( $file.'/html/' . $filename ) ) {
			$filecontent = $left . file_get_contents($file.'/html/' . $filename) . $right;
		} else {
			$filecontent = $left . '<b>Could not find file ' . $filename .'</b>' . $right;
		}
	}

	// Remove unnecessary paragraph wrapping from any content to be embedded into the html
	// And then embed it into the html
	if (! empty( $content ) ) {
		$content = do_shortcode( $content );
		$patterns = array('/^<\/p>/i', '/<p>$/i');
		$content = preg_replace($patterns, '', $content);
		$filecontent = str_replace('@@@ADDEDINFO@@@', $content, $filecontent );
	} else {
		// Remove the @@@ADDEDINFO@@@ embed
		$filecontent = str_replace('@@@ADDEDINFO@@@', '', $filecontent );
	}

	return $filecontent;
}

add_shortcode( 'domainOfTheAncients', 'djv_domainOfTheAncients_shortcode' );

/* --------------------- Functions for updating plugins ------------------------------ */
function djv_domainOfTheAncients_pre_set_site_transient_update_plugins( $transient ) {
 $id = 'domainOfTheAncients/domainOfTheAncients.php';
 $name = 'Domain Of The Ancients';
 $slug = 'domainOfTheAncients';
 return djv_plugin_pre_set_site_transient( $transient, $id, $name, $slug, '3.218.0' );
}
add_filter( 'pre_set_site_transient_update_plugins', 'djv_domainOfTheAncients_pre_set_site_transient_update_plugins' );

function djv_domainOfTheAncients_plugin_info( $result, $action, $args ) {
	$name = 'Domain Of The Ancients';
	$slug = 'domainOfTheAncients';
	if ( 'plugin_information' !== $action ) {
		return $result;
	}
	if ( $slug !== $args->slug) {
		return $result;
	}
	return djv_plugin_get_remote_update_info( $name, $slug );
}
add_filter( 'plugins_api', 'djv_domainOfTheAncients_plugin_info', 10, 3 );

?>