<?php

/* © Copyright 2021, 2022 David Vines

Please see the COPYRIGHT notice in the main .php file for licensing details

*/

/* ------------------ Debugging function in case we need it --------------------------- */
if ( !function_exists('djv_write_log') ) {
	function djv_write_log ( $log )  {
		if ( true === WP_DEBUG ) {
			if ( is_array( $log ) || is_object( $log ) ) {
				error_log( print_r( $log, true ) );
			} else {
				error_log( $log );
			}
		}
	}
}

/* --------------------- Functions for updating plugins ------------------------------ */
if ( !function_exists('djv_plugin_get_remote_update_from') ) {
	function djv_plugin_get_remote_update_from( $sitebase, $uploads, $slug ) {
		$url = $uploads . '/jsons/' . $slug . '.json';
		$remote =  wp_remote_get( $url, array( 'timeout' => 10, 'headers' => array( 'Accept' => 'application/json' ) ) );
		if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
			$remote['uploads'] = $uploads;
			$remote['sitebase'] = $sitebase;
		}
		return $remote;
	}
}
if ( !function_exists('djv_plugin_get_remote_update_info') ) {
	function djv_plugin_get_remote_update_info( $name, $slug ) {
		$remote = get_transient( 'djv_update_' . $slug );
		if (false == $remote || is_wp_error($remote) || !isset( $remote['response']['code'] ) || 200 !== $remote['response']['code'] || empty( $remote['body'] ) ) {
			$sitebase = get_site_url( );
			$upload_dir = wp_upload_dir( );
			if ( is_ssl() ) { $upload_dir['baseurl'] = str_replace( 'http://', 'https://', $upload_dir['baseurl'] ); }
			$remote = djv_plugin_get_remote_update_from( $sitebase, $upload_dir['baseurl'], $slug );
			if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
				set_transient( 'djv_update_' . $slug, $remote, 10 ); // Save for only 10 seconds here
			} else {
				$remote = djv_plugin_get_remote_update_from( 'https://blog.tremlas.com', 'https://blog.tremlas.com/wp-content/uploads', $slug );
				if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
					set_transient( 'djv_update_' . $slug, $remote, 43200 ); // Save for 12 hours
				}
			}
		}
		if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
			$body = json_decode( $remote['body'] );
			$info = new StdClass();
			$info->name = $name;
			$info->slug = $slug;
			$info->version = $body->version;
			$info->requires = $body->requires;
			$info->author = '<a href="' . $body->author_profile . '">' . $body->author . '</a>';
			$info->download_link = $remote['uploads'] . '/' . $body->download_url;
			$info->trunk = $remote['uploads'] . '/' . $body->download_url;
			$info->last_updated = $body->last_updated;
			$info->tested = (isset($body->tested) ? $body->tested : '');
			$changelog = $body->sections->changelog;
			$changelog = str_replace( '<a href="', '<a href="' . $remote['uploads'] . '/' , $changelog );
			$info->sections = array(
				'description'  => implode( "\n", $body->sections->description ),
				'installation' => implode( "\n", $body->sections->installation ),
				'changelog'    => implode( "\n", $changelog ),
			);
			$info->homepage = $remote['sitebase'] . '/' . $body->homepage;
			return $info;
		}
		return false;
	}
}

if ( !function_exists('djv_plugin_check_for_update') ) {
	function djv_plugin_check_for_update( $id, $name, $slug, $version ) {
		$info = djv_plugin_get_remote_update_info( $name, $slug );
		if ( false == $info ) {
			return false;
		}
		if ( version_compare( $version, $info->version, '<' ) && version_compare( $info->requires, get_bloginfo( 'version' ), '<' ) ) {
			$update = (object) array(
				'id'            => $id,
				'slug'          => $slug,
				'plugin'        => $name,
				'new_version'   => $info->version,
				'url'           => $info->homepage,
				'package'       => $info->download_link,
				'icons'         => array(),
				'banners'       => array(),
				'banners_rtl'   => array(),
				'tested'        => $info->tested,
				'requires_php'  => '',
				'compatability' => new StdClass()
			);
			return $update;
		} else {
			return false;
		}
	}
}

if ( !function_exists('djv_plugin_pre_set_site_transient') ) {
	function djv_plugin_pre_set_site_transient( $transient, $id, $name, $slug, $version = '3.218.0' ) {
		// Check for update
		$update = djv_plugin_check_for_update( $id, $name, $slug, $version );
		if ( $update ) {
			$transient->response[$id] = $update;
		} else {
			// No update
			$item = (object) array(
				'id'            => $id,
				'slug'          => $slug,
				'plugin'        => $id,
				'new_version'   => $version,
				'url'           => '',
				'package'       => '',
				'icons'         => array(),
				'banners'       => array(),
				'banners_rtl'   => array(),
				'tested'        => '',
				'requires_php'  => '',
				'compatability' => new StdClass()
			);
			$transient->no_update[$id] = $item;
		}
		return $transient;
	}
}

?>