//
// © 2017 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
/* globals alexisbio: true, options */
alexisbio = {};

alexisbio.captureException = function(f, arg) {
    try {
        f(arg);
    } catch (ex) {
        var exdiv = document.getElementById("exception");
        exdiv.className = exdiv.className.replace(/exhidden/, "exvis");
        var element = document.getElementById("exception.text");
        var text;
        if (ex instanceof Error) {
            text = ex.name + " : " + ex.message;
        } else {
            text = ex.toString();
        }
        text = text + '\n' + (ex.stack || ex.stacktrace || '');

        // Remove the chunk in the stack trace between @ and /js
        text = text.replace(/@.*\/js\//g, " in ");
        // And version field too
        text = text.replace(/\?ver=[0-9a-fA-F]*:/g, ":");

        var newText = document.createTextNode(text);
        if (element.hasChildNodes()) {
            element.replaceChild(newText, element.firstChild);
        } else {
            element.appendChild(newText);
        }
    }
};

alexisbio.captureExceptionFunction = function(f, arg) {
    return function() {
        alexisbio.captureException(f, arg);
    };
};

alexisbio.captureExceptionEventHandler = function(f) {
    return function(e) {
        alexisbio.captureException(f, e);
    };
};

alexisbio.dobutton = function(bids) {
    return function() {
        var prefix = bids[0] + "-" + bids[1] + "-";
        var buttons    = document.getElementById(prefix + bids[2] + "-buttons");
        var newstory   = document.getElementById(prefix + bids[3]);
        var intro      = document.getElementById(prefix + bids[2]);
        var newbuttons = document.getElementById(prefix + bids[4] + "-buttons");
        if (intro) {
            intro.className = intro.className.replace(/abhidden/,"abvis");
        }
        buttons.className  = buttons.className.replace(/abvis/,"abhidden");
        if (newstory) {
            newstory.className = newstory.className.replace(/abhidden/,"abvis");
        } else {
            alexisbio.captureException(function() {throw "Missing story: "+bids[3];},null);
        }
        if (newbuttons) {
            newbuttons.className = newbuttons.className.replace(/abhidden/,"abvis");
        } else if (bids[4]) {
            alexisbio.captureException(function() {throw "Missing buttons: "+bids[4];},null);
        }
    };
};

alexisbio.linkbuttons = function(id) {
    var buttons = document.querySelectorAll('button[id^="djvAlexisBiography-'+id+'-"]');
    for(var i=0; i<buttons.length; i++) {
        var button = buttons[i];
        var bids = button.id.split("-");
        button.onclick = alexisbio.captureExceptionEventHandler(alexisbio.dobutton(bids));
    }
};

for(var i = 0; i < options.ids.length; i++) {
    alexisbio.linkbuttons(options.ids[i]); // Page first so that the new skills (if any) get loaded
}
