<?php
/*
 Plugin Name: Princess Alexis Biography
 Plugin URI: https://blog.tremlas.com/wordpress-plugins/alexis-biography-plugin-details/
 Description: Adds a Biography of Princess Alexis as a shortcode
 Version: 3.161.0
 Author: David Vines
 Author URI: http://tremlas.com
 License:  Creative Commons License
 */
/* © Copyright 2017, 2021 David Vines

Creative Commons License

This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
*/

include_once 'common.php';

/**
 * Shortcode to add the version of the plugin
 */
function djv_princessAlexisBiographyVersion_shortcode() {
	return 'Princess Alexis Biography Version 3.161.0';
}
add_shortcode( 'alexisBiographyVersion', 'djv_princessAlexisBiographyVersion_shortcode' );

/**
 * Shortcode to add a biography of Princess Alexis
 */

// Now for a shortcode that can be used to get links and/or tables for the characters
function djv_princessAlexisBiography_shortcode( $attr, $content = null ) {

	$plugin_url = plugin_dir_url(__FILE__);
	wp_enqueue_script('djv_alexisbio_js', $plugin_url.'js/alexis.js', array(), '3.161.0', true );
	wp_enqueue_style('djv_alexisbio_css', $plugin_url.'css/alexisbio.css', array(), '3.161.0');

	static $id = 0; $id++;

	$text  = '' . PHP_EOL;

	$file = plugin_dir_path(__FILE__);
	$filecontent = file_get_contents($file.'/html/bio.html');
	$filecontent = str_replace('@@@ID@@@', $id, $filecontent );

	$text .= $filecontent . PHP_EOL;

	$text .= '<script type="text/javascript">' . PHP_EOL;
	$text .= 'var options = options || {};' . PHP_EOL;
	$text .= 'options.ids = options.ids || [];' . PHP_EOL;
	$text .= 'options.ids.push(' . $id . ');' . PHP_EOL;
	$text .= '</script>' . PHP_EOL;

	return $text;
}

add_shortcode( 'alexisBiography', 'djv_princessAlexisBiography_shortcode' );

/* --------------------- Functions for updating plugins ------------------------------ */
function djv_PrincessAlexisBiography_pre_set_site_transient_update_plugins( $transient ) {
 $id = 'PrincessBiography/PrincessBiographyPlugin.php';
 $name = 'Princess Alexis Biography';
 $slug = 'PrincessBiography';
 return djv_plugin_pre_set_site_transient( $transient, $id, $name, $slug, '3.161.0' );
}
add_filter( 'pre_set_site_transient_update_plugins', 'djv_PrincessAlexisBiography_pre_set_site_transient_update_plugins' );

function djv_PrincessAlexisBiography_plugin_info( $result, $action, $args ) {
	$name = 'Princess Alexis Biography';
	$slug = 'PrincessBiography';
	if ( 'plugin_information' !== $action ) {
		return $result;
	}
	if ( $slug !== $args->slug) {
		return $result;
	}
	return djv_plugin_get_remote_update_info( $name, $slug );
}
add_filter( 'plugins_api', 'djv_PrincessAlexisBiography_plugin_info', 10, 3 );

?>