<?php
/*
Plugin Name: Sumo Oyakata
Plugin URI: https://blog.tremlas.com/wordpress-plugins/sumo-oyakata-plugin-details/
Description: Adds a shortcode that inserts the Sumo Oyakata game
Version: 3.114.0
Author: David Vines
Author URI: http://tremlas.com
License:  Creative Commons License
*/
/* © Copyright 2021 David Vines

   Creative Commons License

   This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
*/

// Debugging function in case we need it
if ( !function_exists('djv_write_log') ) {
	function djv_write_log ( $log )  {
		if ( true === WP_DEBUG ) {
			if ( is_array( $log ) || is_object( $log ) ) {
				error_log( print_r( $log, true ) );
			} else {
				error_log( $log );
			}
		}
	}
}

/**
 * Shortcode to add the version of the plugin
 */
function djv_sumoOyakata_sumoOyakataVersion_shortcode() {
	return 'Sumo Oyakata Version 3.114.0';
}
add_shortcode( 'sumoOyakataVersion', 'djv_sumoOyakata_sumoOyakataVersion_shortcode' );

/**
 * Add the "Sumo Oyakata". Only one per page is supported.
 */

// Now for a shortcode that can be used to get links and/or tables for the characters
function djv_sumoOyakata_shortcode( $attr, $content = null ) {
	$plugin_url = plugin_dir_url(__FILE__);
	wp_enqueue_script('djv_sumoOyakata_rot', $plugin_url.'js/rot/rot.min.js' );
	wp_enqueue_script('djv_sumoOyakata_names', $plugin_url.'js/sumoOyakata/names.js' );
	wp_enqueue_script('djv_sumoOyakata_rikishi', $plugin_url.'js/sumoOyakata/rikishi.js' );
	wp_enqueue_script('djv_sumoOyakata_bout', $plugin_url.'js/sumoOyakata/bout.js' );
	wp_enqueue_script('djv_sumoOyakata_game', $plugin_url.'js/sumoOyakata/game.js' );

	wp_enqueue_style('djv_sumoOyakataStyle', $plugin_url.'css/sumoOyakata.css');

	$file = plugin_dir_path(__FILE__);
	$filecontent = file_get_contents($file.'/html/sumoOyakata.html');

	return $filecontent;
}

add_shortcode( 'sumoOyakata', 'djv_sumoOyakata_shortcode' );

/* --------------------- Functions for updating plugins ------------------------------ */
function djv_sumoOyakata_get_remote_update_from( $urlbase, $slug ) {
 $url = $urlbase . '/wp-content/uploads/jsons/' . $slug . '.json';
 $remote =  wp_remote_get( $url, array( 'timeout' => 10, 'headers' => array( 'Accept' => 'application/json' ) ) );
 if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
  $remote['urlbase'] = $urlbase;
 }
 return $remote;
}
function djv_sumoOyakata_get_remote_update_info( $slug ) {
 $remote = get_transient( 'djv_update_' . $slug );
 if (false == $remote || is_wp_error($remote) || !isset( $remote['response']['code'] ) || 200 !== $remote['response']['code'] || empty( $remote['body'] ) ) {
 	if ( 'cubi' == gethostname() ) {
 		$remote = djv_sumoOyakata_get_remote_update_from( 'http://cubi.internal', $slug );
 		set_transient( 'djv_update_' . $slug, $remote, 10 ); // Save for only 10 seconds here
 	} else {
 		$remote = djv_sumoOyakata_get_remote_update_from( 'https://blog.tremlas.com', $slug );
 		set_transient( 'djv_update_' . $slug, $remote, 43200 ); // Save for 12 hours
 	}
 }
 if (false == $remote || is_wp_error($remote) || !isset( $remote['response']['code'] ) || 200 !== $remote['response']['code'] || empty( $remote['body'] ) ) {
  $remote = djv_sumoOyakata_get_remote_update_from( 'https://blog.tremlas.com', $slug );
  set_transient( 'djv_update_' . $slug, $remote, 43200 ); // Save for 12 hours
 }
 if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
  $body = json_decode( $remote['body'] );
  $info = new StdClass();
  $info->name = 'Sumo Oyakata';
  $info->slug = $slug;
  $info->version = $body->version;
  $info->requires = $body->requires;
  $info->author = '<a href="' . $body->author_profile . '">' . $body->author . '</a>';
  $info->download_link = $remote['urlbase'] . '/' . $body->download_url;
  $info->trunk = $remote['urlbase'] . '/' . $body->download_url;
  $info->last_updated = $body->last_updated;
  $info->sections = array(
    'description'  => implode( "\n", $body->sections->description ),
    'installation' => implode( "\n", $body->sections->installation ),
    'changelog'    => implode( "\n", $body->sections->changelog ),
  );
  $info->homepage = $remote['urlbase'] . '/' . $body->homepage;
  return $info;
 }
 return false;
}

function djv_sumoOyakata_check_for_update( $name, $slug ) {
 $info = djv_sumoOyakata_get_remote_update_info( $slug );
 if ( false == $info ) {
  return false;
 }
 if ( version_compare( '3.114.0', $info->version, '<' ) && version_compare( $info->requires, get_bloginfo( 'version' ), '<' ) ) {
  $update = (object) array(
    'id'            => $name,
    'slug'          => $slug,
    'plugin'        => $name,
    'new_version'   => $info->version,
    'url'           => $info->homepage,
    'package'       => $info->download_link,
    'icons'         => array(),
    'banners'       => array(),
    'banners_rtl'   => array(),
    'tested'        => '',
    'requires_php'  => '',
    'compatability' => new StdClass()
  );
  return $update;
 } else {
  return false;
 }
}

function djv_sumoOyakata_pre_set_site_transient_update_plugins( $transient ) {
 // Check for update
 $pluginphp = 'sumoOyakata/sumoOyakata.php';
 $pluginslug = 'sumoOyakata';
 $update = djv_sumoOyakata_check_for_update( $pluginphp, $pluginslug );
 if ( $update ) {
  $transient->response[$pluginphp] = $update;
 } else {
  // No update
  $item = (object) array(
    'id'            => $pluginphp,
    'slug'          => $pluginslug,
    'plugin'        => $pluginphp,
    'new_version'   => '3.114.0',
    'url'           => '',
    'package'       => '',
    'icons'         => array(),
    'banners'       => array(),
    'banners_rtl'   => array(),
    'tested'        => '',
    'requires_php'  => '',
    'compatability' => new StdClass()
  );
  $transient->no_update[$pluginphp] = $item;
 }
 return $transient;
}
add_filter( 'pre_set_site_transient_update_plugins', 'djv_sumoOyakata_pre_set_site_transient_update_plugins' );

function djv_sumoOyakata_plugin_info( $result, $action, $args ) {
 $slug = 'sumoOyakata';
 if ( 'plugin_information' !== $action ) {
  return $result;
 }
 if ( $slug !== $args->slug) {
  return $result;
 }
 return djv_sumoOyakata_get_remote_update_info( $slug );
}
add_filter( 'plugins_api', 'djv_sumoOyakata_plugin_info', 10, 3 );

?>