/*!
 * © 2021 David Vines
 *
 * Creative Commons License
 *
 * This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
 */

/* globals Names, ROT, OpeningMove, Continuation */
/* exported Rikishi */
class Rikishi {
	constructor() {
		this._name = Names.getAName();
		this._int = ROT.RNG.getPercentage();
		this._spd = ROT.RNG.getPercentage();
		this._agl = ROT.RNG.getPercentage();
		this._str = ROT.RNG.getPercentage();
		this._wgt = ROT.RNG.getPercentage();
		this._bal = ROT.RNG.getPercentage();
		this._wins = 0;
		this._losses = 0;
		this._played = [];
	}
	getIntelligence() {
		return this._int;
	}
	getSpeed() {
		return this._spd;
	}
	getAgility() {
		return this._agl;
	}
	getStrength() {
		return this._str;
	}
	getWeight() {
		return this._wgt;
	}
	getBalance() {
		return this._bal;
	}
	hasPlayed(rikishi) {
		return this._played.includes(rikishi);
	}
	played(rikishi) {
		this._played.push(rikishi);
	}
	_getMove(them,options) {
		// Build the specific score matrix for this matchup
		let matrix = [];
		for(let i=0; i<options.length; i++) {
			matrix[i] = [];
			for(let j=0; j<options.length; j++) {
				matrix[i][j]  = options[i].getOdds(options[j],this,them)*(100-(them.getBalance()+24)/5);
				matrix[i][j] -= options[j].getOdds(options[i],them,this)*(100-(this.getBalance()+24)/5);
			}
		}
		let oddments = new Array(options.length).fill(0);
		let rowtotal = new Array(options.length).fill(0);
		let coltotal = new Array(options.length).fill(0);
		let ourmove = Math.floor(ROT.RNG.getUniform()*options.length);
		for(let i=0; i<this.getIntelligence()-1; i++) {
			oddments[ourmove] += 1/this.getIntelligence();
			for(let j=0; j<options.length; j++) {
				coltotal[j] += matrix[ourmove][j];
			}
			let lowest = coltotal[0], lowcol = [0];
			for(let j=1; j<coltotal.length; j++) {
				if (coltotal[j] < lowest) {
					lowest = coltotal[j]; lowcol = [j];
				} else if (coltotal[j] === lowest) {
					lowcol.push(j);
				}
			}
			const theirmove = ROT.RNG.getItem(lowcol);

			for(let j=0; j<options.length; j++) {
				rowtotal[j] += matrix[j][theirmove];
			}
			let highest = rowtotal[0], highrow = [0];
			for(let j=1; j<rowtotal.length; j++) {
				if (rowtotal[j] > highest) {
					highest = rowtotal[j]; highrow = [j];
				} else if (rowtotal[j] === highest) {
					highrow.push(j);
				}
			}
			ourmove = ROT.RNG.getItem(highrow);
		}
		oddments[ourmove] += 1/this.getIntelligence();

		// And make the choice
		let roll = ROT.RNG.getUniform(), choice = 0;
		while(roll > oddments[choice]) {
			roll -= oddments[choice++];
		}
		return options[choice];
	}
	getOpeningMove(them) {
		return this._getMove(them,[OpeningMove.Charge,OpeningMove.Attack,OpeningMove.StepAside,OpeningMove.Slap]);
	}
	getContinuation(them) {
		return this._getMove(them,[Continuation.Lever,Continuation.Lift,Continuation.Push,Continuation.Pull]);
	}
	saves() {
		return (ROT.RNG.getPercentage() < (this._bal+5)/5);
	}
	toString() {
		return this._name;
	}
	getScore() {
		return this._wins+"-"+this._losses;
	}
	addWin() {
		this._wins++;
	}
	addLoss() {
		this._losses++;
	}
	getWins() {
		return this._wins;
	}
	getLosses() {
		return this._losses;
	}
}
