/*!
 * © 2021 David Vines
 *
 * Creative Commons License
 *
 * This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
 */

/* globals Names, Rikishi, Bout, ROT */
var Game =  {
	MAKUUCHI_SIZE: 42,
	captureException: function(f,arg) {
		try {
			f(arg);
		} catch(ex) {
			var exdiv = document.getElementById("exception");
			exdiv.className = exdiv.className.replace(/exhidden/,"exvis");
			var element = document.getElementById("exception.text");
			var text;
			if (ex instanceof Error) {
				text = ex.name+" : "+ex.message;
			} else {
				text = ex.toString();
			}
			text = text + '\n' + (ex.stack || ex.stacktrace || '');

			// Remove the chunk in the stack trace between @ and /js/sumoOyakata/
			text = text.replace(/@.*\/js\/sumoOyakata\//g," in ");
			// And version field too
			text = text.replace(/\?ver=[0-9a-fA-F]*:/g,":");

			var newText = document.createTextNode(text);
			if (element.hasChildNodes()) {
				element.replaceChild(newText, element.firstChild);
			} else {
				element.appendChild(newText);
			}
			debugger; // jshint ignore:line
		}
	},
	captureExceptionFunction: function(f, arg) {
		return function() {
			Game.captureException(f,arg);
		};
	},
	captureExceptionEventHandler: function(f) {
		return function(e) {
			Game.captureException(f,e);
		};
	},
	_replaceText: function(id,text) {
		let node = document.getElementById(id);
		node.replaceChild(document.createTextNode(text),node.firstChild);
	},
	_updateTable: function() {
		Game.rikishi.sort(function(a,b) {
			if (a.getWins() > b.getWins()) return -1;
			if (a.getWins() < b.getWins()) return 1;
			if (a.getLosses() < b.getLosses()) return -1;
			if (a.getLosses() > b.getLosses()) return 1;
			if (a.toString() > b.toString()) return 1;
			if (a.toString() < b.toString()) return -1;
			return 0;
		});
		for(let i=0; i<Game.MAKUUCHI_SIZE; i++) {
			Game._replaceText("r"+i+"name" ,Game.rikishi[i].toString());
			Game._replaceText("r"+i+"int"  ,Game.rikishi[i].getIntelligence());
			Game._replaceText("r"+i+"spd"  ,Game.rikishi[i].getSpeed());
			Game._replaceText("r"+i+"agl"  ,Game.rikishi[i].getAgility());
			Game._replaceText("r"+i+"str"  ,Game.rikishi[i].getStrength());
			Game._replaceText("r"+i+"wgt"  ,Game.rikishi[i].getWeight());
			Game._replaceText("r"+i+"bal"  ,Game.rikishi[i].getBalance());
			Game._replaceText("r"+i+"score",Game.rikishi[i].getScore());
		}
	},
	_combatantText: function(east,west) {
		return east.toString()+" ("+east.getScore()+") and "+west.toString()+" ("+west.getScore()+")";
	},
	_setupDay: function() {
		Game._todaysBouts = [];
		let tryWindow = 1; // Size of the window within which to pick opponent
		while(Game._todaysBouts.length === 0) {
			// Highest differences first
			const rikishiSortOrder = function(a,b) {
				return Math.abs(b.getWins()-b.getLosses())+(ROT.RNG.getUniform()-0.5) - Math.abs(a.getWins()-a.getLosses());
			};
			let rikishiOrder = Game.rikishi.slice().sort(rikishiSortOrder);
			while(rikishiOrder.length != 0) {
				const firstRikishi = rikishiOrder.shift();
				// clone the array, remove those rikishi first has already played and then sort it by the win difference (if permitted)
				const ors = rikishiOrder.slice();
				const orsm = ors.filter(function(r) { return !r.hasPlayed(firstRikishi); } );
				if (orsm.length !== 0) {
					const winSortOrder = function(a,b) {
						return (Math.abs(a.getWins() - firstRikishi.getWins()) - Math.abs(b.getWins() - firstRikishi.getWins()));
					};
					const orsmo = orsm.slice().sort(winSortOrder);
					const orsmos = orsmo.slice(0,tryWindow);
					const otherRikishi = ROT.RNG.getItem(orsmos);
					Game._todaysBouts.push([firstRikishi,otherRikishi]);
					rikishiOrder = rikishiOrder.filter(function(r) { return r !== otherRikishi; } );
				} else {
					// Abort this attempt
					Game._todaysBouts = [];
					rikishiOrder = [];
					tryWindow++; // Widen the window
				}
			}
		}
		// But rikishi with the lowest wins totals first
		const gameSortOrder = function(a,b) {
			return (a[0].getWins()+a[1].getWins()) - (b[0].getWins()+b[1].getWins());
		};
		Game._todaysBouts = Game._todaysBouts.sort(gameSortOrder);
		for(let i =0; i<Game._todaysBouts.length; i++)
		{
			const firstRikishi = Game._todaysBouts[i][0];
			const otherRikishi = Game._todaysBouts[i][1];
			firstRikishi.played(otherRikishi);
			otherRikishi.played(firstRikishi);
		}
	},
	_setupBout: function(east,west,boutname) {
		const bout = document.getElementById("bout");
		while (bout.firstChild) {
			bout.removeChild(bout.firstChild);
		}
		east = east || Game._todaysBouts[Game._bout][0];
		west = west || Game._todaysBouts[Game._bout][1];
		boutname = boutname || Game._bout+1;
		Game._result = Bout.resolve(east,west);
		Game._replaceText("boutno",boutname);
		Game._replaceText("eastname",east.toString()+" ("+east.getScore()+")");
		Game._replaceText("westname",west.toString()+" ("+west.getScore()+")");
		Game._resultLinesShown = 0;
		document.getElementById("next").disabled = true;
		Game._showNextResultLine();
	},
	_endGame: function(first) {
		if (Game._winners.length == 1) {
			Game._replaceText("next","Tournament completed and the Tournament Champion is "+Game.rikishi[0].toString());
		} else if (Game._winners.length === 2) {
			Game._replaceText("next","Tie-break between "+Game._winners[0].toString()+" and "+Game._winners[1].toString());
			document.getElementById("next").disabled = false;
			document.getElementById("next").onclick = function() { Game.captureException(function() {
				Game._setupBout(Game._winners[0],Game._winners[1],"Tie-breaker");
			}); };
		} else if (Game._winners.length === 3) {
			Game._prevWinner = null;
			Game._replaceText("next",first+" Tie-break match between "+Game._winners[0].toString()+" and "+Game._winners[1].toString());
			document.getElementById("next").disabled = false;
			document.getElementById("next").onclick = function() { Game.captureException(function() {
				Game._setupBout(Game._winners[0],Game._winners[1],"Tie-breaker");
			}); };
		} else {
			Game._nextRound = [];
			Game._winners = ROT.RNG.shuffle(Game._winners);
			if (Game._winners.length%2 === 1 ) {
				Game._nextRound.push(Game._winners[Game._winners.length-2]);
			}
			Game._replaceText("next",first+" Tie-break match between "+Game._winners[0].toString()+" and "+Game._winners[1].toString());
			Game._nextIndex = 2;
			document.getElementById("next").disabled = false;
			document.getElementById("next").onclick = function() { Game.captureException(function() {
				Game._setupBout(Game._winners[0],Game._winners[1],"Tie-breaker");
			}); };
		}
	},
	_showNextResultLine: function() {
		if (Game._resultLinesShown < Game._result.getText().length) {
			const bout = document.getElementById("bout");
			let element = document.createElement("li");
			let textnode = document.createTextNode(Game._result.getText()[Game._resultLinesShown++]);
			element.appendChild(textnode);
			bout.appendChild(element);
			window.setTimeout(() => { Game.captureException(Game._showNextResultLine); }, 1000);
		} else {
			if (Game._bout < Game.MAKUUCHI_SIZE/2-1) {
				Game._result.getWinner().addWin();
				Game._result.getLoser().addLoss();
				Game._updateTable();
				Game._bout++;
				Game._replaceText("next","Next Bout is between "+Game._combatantText(Game._todaysBouts[Game._bout][0],Game._todaysBouts[Game._bout][1]));
				document.getElementById("next").disabled = false;
				document.getElementById("next").onclick = function() { Game.captureException(function() {
					Game._setupBout();
				}); };
			} else if (Game._day < 14) {
				Game._result.getWinner().addWin();
				Game._result.getLoser().addLoss();
				Game._updateTable();
				Game._day++;
				Game._setupDay();
				Game._bout = 0;
				Game._replaceText("next","Next Day. First bout is between "+Game._combatantText(Game._todaysBouts[Game._bout][0],Game._todaysBouts[Game._bout][1]));
				document.getElementById("next").disabled = false;
				document.getElementById("next").onclick = function() { Game.captureException(function() {
					Game._replaceText("day",Game._day+1);
					Game._setupBout();
				}); };
			} else if (Game._winners === null) {
				Game._winners = [Game.rikishi[0]];
				for(let i=1; (Game.rikishi[i].getWins() == Game.rikishi[0].getWins()) && i<Game.MAKUUCHI_SIZE; i++) {
					Game._winners.push(Game.rikishi[i]);
				}
				Game._endGame("First");
			} else if (Game._winners.length === 1) {
				// All done
			} else if (Game._winners.length === 2) {
				Game._winners = [Game._result.getWinner()];
				Game._replaceText("next","Tournament completed and the Tournament Champion is "+Game._winners[0].toString());
			} else if (Game._winners.length === 3) {
				if (Game._result.getWinner() === Game._prevWinner) {
					Game._winners = [Game._result.getWinner()];
					Game._replaceText("next","Tournament completed and the Tournament Champion is "+Game._winners[0].toString());
				} else {
					Game._prevWinner = Game._result.getWinner();
					const east = Game._prevWinner;
					let west = Game._winners[0].toString();
					if (west === Game._result.getWinner() || west === Game._result.getLoser()) west = Game._winners[1].toString();
					if (west === Game._result.getWinner() || west === Game._result.getLoser()) west = Game._winners[2].toString();
					Game._replaceText("next","Next Tie-break match between "+east+" and "+west);
					document.getElementById("next").onclick = function() { Game.captureException(function() {
						Game._setupBout(east,west,"Tie-breaker");
					}); };
				}
			} else {
				// Game._winners.length > 3
				Game._nextRound.push(Game._result.getWinner());
				if (Game._nextIndex >= Game._winners.length-1) {
					Game._winners = Game._nextRound;
					Game.endGame("Next");
				} else {
					Game._replaceText("next","Next Tie-break match between "+Game._winners[Game._nextIndex].toString()+" and "+Game._winners[Game._nextIndex+1].toString());
					document.getElementById("next").disabled = false;
					document.getElementById("next").onclick = function() { Game.captureException(function() {
						Game._setupBout(Game._winners[Game._nextIndex],Game._winners[Game._nextIndex+1],"Tie-breaker");
					}); };
					Game._nextIndex += 2;
				}
			}
		}
	},
	init: function() {
		Names.init();
		Game.rikishi = [new Rikishi()];
		for(let i=1; i<Game.MAKUUCHI_SIZE; i++) {
			let duplicate = true;
			let r;
			while(duplicate) {
				r = new Rikishi(); duplicate = false;
				for(let j=0; j<i; j++) {
					duplicate |= (r.toString() == Game.rikishi[j].toString());
				}
			}
			Game.rikishi.push(r);
		}

		Game._updateTable();
		Game._winners = null;
		for(let r=0; r<Game.rikishi.length; r++) {
			Game._played = [];
		}
		Game._setupDay();
		Game._day = 0;
		Game._bout = 0;
		Game._setupBout();
	}
};

window.onload = function() {
	Game.captureException(Game.init);
};
