<?php
/**
 * Template Name: Liftoff News
 * @since ningxia 1.0.0
 **/
get_header ();
?>
<div id="content">
 <div class="widest-container">
  <div id="widest-main">
   <div class="section archive">
    <?php if(have_posts()) : ?><?php while(have_posts()) : the_post(); ningxia_update_years(); ?>
     <?php
       $pieces = explode ( ' ', get_the_title () );
       $year = ( int ) array_pop ( $pieces );
     ?>
     <div class="wp-caption entry-title">
      <h1> The Journal of Space Achievement <?php echo $year; ?></h1>
      <p style="font-size: x-small">Recording the events of <?php echo $year; ?></p>
     </div>
     <div class="post liftoff-news">
      <?php the_content(); ?>
     </div><!--  post liftoff-news -->
     <div class="post liftoff-news-budget">
      <h2>Financial summary as of 1<sup>st</sup> January <?php echo $year+1 ?></h2>
      <?php $liftoffAgencies = array("SMAUG","SARSA","GOSsiP","SHADO","ASA"); $liftoffLinks = false; ?>
      <table>
       <tr>
        <th>Agency</th>
        <th>Cash in hand</th>
        <th>Expected Budget for <?php echo $year+2 ?></th>
       </tr>
       <?php foreach ($liftoffAgencies as $liftoffAgency) : ?>
        <tr>
         <?php $liftoffAgencyLink = get_post_meta( get_the_ID(), $liftoffAgency . '_LINK', true); ?>
         <td>
          <!-- <?php echo $liftoffAgencyLink; ?> -->
          <?php
           if (! empty ( $liftoffAgencyLink )) :
            $liftoffLinks = true;
          ?>
           <a href="<?php echo $liftoffAgencyLink; ?>">
          <?php endif; ?>
          <?php echo get_post_meta( get_the_ID(), $liftoffAgency . '_NAME', true); ?>
          <?php if ( ! empty( $liftoffAgencyLink ) ) : ?>
           </a>
          <?php endif; ?>
         </td>
         <td><?php echo get_post_meta( get_the_ID(), $liftoffAgency . '_CIH', true); ?></td>
         <td><?php echo get_post_meta( get_the_ID(), $liftoffAgency . '_BUDGET', true); ?></td>
        </tr>
       <?php endforeach; ?>
      </table>
      <?php if ( $liftoffLinks ) : ?>
       <p>Click on the name of the agency to see details on the agency's safety factors, astronaut roster and
       hardware stocks.</p>
      <?php endif ?>
      <div class="clear"><hr/></div>
      <?php wp_nav_menu( array('theme_location' => 'liftoff', 'container_class' => 'liftoff-links') ); ?>
     </div><!-- post liftoff-news-budget -->
    <?php endwhile;endif; ?>
    <?php comments_template(); ?>
   </div><!-- section entry -->
  </div><!-- widest-main -->
 </div><!-- widest-container -->
</div><!-- content -->
<div class="clear"></div>
<?php	get_footer(); ?>
