<?php
/**
 * @since ningxia 1.0.0
 */

get_header();
?>
<?php $static = ningxia_get_theme_option( 'static' ); ?>
<div id="content">
	<div class="container">
		<div id="main">
			<div class="section archive">
				<?php if(have_posts()) : ?><?php while(have_posts()) : the_post();  ningxia_update_years(); ?>
				<article class="post">
					<h1 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permalink to %s', 'ningxia' ), the_title_attribute( 'echo=0' ) ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h1>
					<div class="infometa author">
						<?php the_time( get_option( 'date_format' )); ?>
						<?php if ( $static != "on" ) : ?>
							<span class="seprator">/</span>	
							<?php comments_popup_link(); ?>
						<?php endif; ?>
					</div>
					<?php the_attachment_link( $post->ID, true );?>
					<h3>Image Metadata</h3>				
					<dl>
						<?php $alttext = get_post_meta($post->ID, '_wp_attachment_image_alt', true); ?>
						<?php $caption = get_the_excerpt(); ?>
						<?php $descrip = get_the_content(); ?>
						<?php $somethingadded = false;?>
						<?php if( is_string( $alttext ) && $alttext !== '') : ?>
							<dt>Alt Text</dt><dd><?php echo $alttext; ?></dd>
							<?php $somethingadded = true; ?>
						<?php endif; ?>
						<?php if( is_string( $caption ) && $caption !== '' && trim(strip_tags($descrip)) !== trim(strip_tags($caption)) ) : ?>
							<dt>Caption</dt><dd><?php the_excerpt(); ?></dd>
							<?php $somethingadded = true; ?>
						<?php endif; ?>
						<?php if( is_string( $descrip ) && $descrip !== '' ) : ?>
							<dt>Description</dt><dd><?php the_content(); ?></dd>
							<?php $somethingadded = true; ?>
						<?php endif; ?>
						<?php if ( !$somethingadded ) : ?>
							<dt></dt><dd>(No metadata found for this image)</dd>
						<?php endif; ?>
						<?php $terms = get_the_terms( $post->ID, 'attachment_tag' );
						if ( $terms && ! is_wp_error( $terms ) ) : ?>
							<dt>Copyright status</dt><dd><?php foreach ( $terms as $term ) {	?>
								<?php if ( $term->name == 'sole-copyright-owner-me' ) : ?>
									<?php $publish = (int)get_the_date( 'Y' ); ?>
									<p>© David Vines <?php echo $publish; ?>. You may use this image if you abide by the terms of the <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License</a>.</p>
								<?php else: ?>
									<p><?php echo $term->description; ?></p>
								<?php endif; ?>
							<?php } ?>
							</dd>
						<?php endif; ?>
					</dl>	
				</article>
				<?php endwhile;endif; ?>
				<div class="clear"></div>
				<?php comments_template(); ?>
			</div><!-- section entry -->
			<div class="page_navi">
				<?php ningxia_paging_nav(); ?>
			</div><!-- page navi -->
		</div><!-- main -->
		<div id="minisidebar" class="col minisidebar">
			<?php get_sidebar('left'); ?>
		</div>
	</div>
</div><!-- content -->
<div id="sidebar">
	<?php get_sidebar(); ?>
</div><!-- sidebar -->
<div class="clear"></div>
<?php	get_footer(); ?>