<?php
// Exit if accessed directly
if ( !defined('ABSPATH')) exit;

function ningxia_child_enqueue_styles() {
 $parent_style = 'ningxia-style';
 wp_enqueue_style( $parent_style, get_template_directory_uri().'/style.css');
 wp_enqueue_style( 'ningxia-child-style', get_stylesheet_directory_uri().'/style.css', array( $parent_style), wp_get_theme()->get('Version'));
}
add_action( 'wp_enqueue_scripts', 'ningxia_child_enqueue_styles' );

function ningxia_child_setup() {

 /*
  * Make Twenty Fourteen available for translation.
  *
  * Translations can be added to the /languages/ directory.
  * If you're building a theme based on Twenty Fourteen, use a find and
  * replace to change 'twentyfourteen' to the name of your theme in all
  * template files.
  */

 register_nav_menus( array(
   'liftoff'  => __( 'Liftoff! Navigation', 'ningxia'),
   'en-garde' => __( 'En Garde Navigation', 'ningxia')
 ) );
}
add_action( 'after_setup_theme', 'ningxia_child_setup' );

function ningxia_child_page_template_styles() {
 if ( is_page_template( 'chronicle-page.php') ) {
  wp_enqueue_style( 'page-template', get_stylesheet_directory_uri() . '/chronicle.css' );
 }
}
add_action( 'wp_enqueue_scripts', 'ningxia_child_page_template_styles' );

function ningxia_child_remove_query_strings() {
 if(!is_admin()) {
  add_filter('script_loader_src', 'ningxia_child_remove_query_strings_split', 15);
  add_filter('style_loader_src', 'ningxia_child_remove_query_strings_split', 15);
 }
}

function ningxia_child_remove_query_strings_split($src){
 if( strpos( $src, '?ver=' ) )
  $src = remove_query_arg( 'ver', $src );
 return $src;
}
add_action('init', 'ningxia_child_remove_query_strings');

function ningxia_child_mimetypes( $mime_types ) {
 $mime_types['json'] = 'application/json'; // Adding .json extension
 return $mime_types;
}
add_filter( 'upload_mimes', 'ningxia_child_mimetypes' );

function ningxia_child_tag_cloud_args( $cloud_args ){
 $cloud_args['smallest'] = 8;
 $cloud_args['largest'] = 28;
 $cloud_args['unit'] = 'px';
 return $cloud_args;
}

add_filter('widget_tag_cloud_args', 'ningxia_child_tag_cloud_args');

/* --------------------- Functions for updating themes ------------------------------ */
function ningxia_child_get_remote_update_from( $urlbase, $slug ) {
 $url = $urlbase . '/wp-content/uploads/jsons/' . $slug . '.json';
 $remote =  wp_remote_get( $url, array( 'timeout' => 10, 'headers' => array( 'Accept' => 'application/json' ) ) );
 if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
  $remote['urlbase'] = $urlbase;
 }
 return $remote;
}
function ningxia_child_get_remote_update_info( $slug ) {
 $remote = get_transient( 'djv_update_' . $slug );
 if (false == $remote) {
  if ( 'cubi' == gethostname() ) {
   $remote = ningxia_child_get_remote_update_from( 'http://cubi.internal', $slug );
   if (false !== $remote) {
    set_transient( 'djv_update_' . $slug, $remote, 10 ); // Save for only 10 seconds here
   }
  }
 }
 if (false == $remote || is_wp_error($remote) || !isset( $remote['response']['code'] ) || 200 !== $remote['response']['code'] || empty( $remote['body'] ) ) {
  $remote = ningxia_child_get_remote_update_from( 'https://blog.tremlas.com', $slug );
  set_transient( 'djv_update_' . $slug, $remote, 43200 ); // Save for 12 hours
 }
 if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
  $body = json_decode( $remote['body'] );
  $info =array(
    'name'          => 'Ningxia Child',
    'slug'          => $slug,
    'version'       => $body->version,
    'requires'      => $body->requires,
    'author'        => '<a href="' . $body->author_profile . '">' . $body->author . '</a>',
    'download_link' => $remote['urlbase'] . '/' . $body->download_url,
    'trunk'         => $remote['urlbase'] . '/' . $body->download_url,
    'last_updated'  => $body->last_updated,
    'sections'      => array(
      'description'  => implode( "\n", $body->sections->description ),
      'installation' => implode( "\n", $body->sections->installation ),
      'changelog'    => implode( "\n", $body->sections->changelog ),
    ),
    'homepage'      => $remote['urlbase'] . '/' . $body->homepage
  );
  return $info;
 }
 return false;
}

function ningxia_child_check_for_update( $slug ) {
 $info = ningxia_child_get_remote_update_info( $slug );
 if ( false == $info ) {
  return false;
 }
 if ( version_compare( '3.97.0', $info['version'], '<' ) && version_compare( $info['requires'], get_bloginfo( 'version' ), '<' ) ) {
  $update = array(
    'slug'          => $slug,
    'new_version'   => $info['version'],
    'url'           => $info['homepage'],
    'package'       => $info['download_link'],
    'icons'         => array(),
    'banners'       => array(),
    'banners_rtl'   => array(),
    'tested'        => '',
    'requires_php'  => '',
    'compatability' => new StdClass()
  );
  return $update;
 } else {
  return false;
 }
}

function ningxia_child_pre_set_site_transient_update_themes( $transient ) {
 // Check for update
 $themeslug = 'NingxiaChild';
 $update = ningxia_child_check_for_update( $themeslug );
 if ( $update ) {
  $transient->response[$themeslug] = $update;
 }
 return $transient;
}
add_filter( 'pre_set_site_transient_update_themes', 'ningxia_child_pre_set_site_transient_update_themes' );

function ningxia_child_theme_info( $result, $action, $args ) {
 $slug = 'NingxiaChild';
 if ( 'plugin_information' !== $action ) {
  return $result;
 }
 if ( $slug !== $args->slug) {
  return $result;
 }
 return ningxia_child_get_remote_update_info( $slug );
}
add_filter( 'themes_api', 'ningxia_child_theme_info', 10, 3 );

?>