<?php
/*
Plugin Name: Latin Squares
Plugin URI: http://blog.tremlas.com/latin-squares-plugin-details/
Description: Adds a shortcode that inserts a helper for latin squares
Version: 3.76.0
Author: David Vines
Author URI: http://blog.tremlas.com
License:  Creative Commons License
*/
/* © Copyright 2014, 2016 David Vines

   Creative Commons License

   This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
*/

// Debugging function in case we need it
if ( !function_exists('djv_write_log') ) {
	function djv_write_log ( $log )  {
		if ( true === WP_DEBUG ) {
			if ( is_array( $log ) || is_object( $log ) ) {
				error_log( print_r( $log, true ) );
			} else {
				error_log( $log );
			}
		}
	}
}

/**
 * Shortcode to add the version of the plugin
 */
function djv_latinSquare_latinSquareVersion_shortcode() {
	return 'Latin Squares Version 3.76.0';
}
add_shortcode( 'latinsquareVersion', 'djv_latinSquare_latinSquareVersion_shortcode' );

/**
 * Inserts a helper for puzzles that involve a single latin square.
 * 
 * Only one can be inserted per page in this implementation
 * 
 * A 'size' attribute can be specified to define the size of the
 * latin square, defaults to 6.
 */

// Now for a shortcode that can be used to get links and/or tables for the characters
function djv_latinSquare_shortcode( $attr, $content = null ) {
	$plugin_url = plugin_dir_url(__FILE__);
	wp_enqueue_script('djv_latin', $plugin_url.'js/latin.js' );
	wp_enqueue_script('djv_latinsquare', $plugin_url.'js/latinsquare.js' );
	wp_enqueue_style('djv_latinsquare_css', $plugin_url.'css/latin.css');
	
	
	if ( isset($attr) && isset( $attr['size'] ) ) {
		$size = (int)$attr['size'];
	} else {
		$size = 6;
	}
	
	$text  = '<script>' . PHP_EOL;
	$text .= 'window.onload = function() { reset(' . $size . '); }' . PHP_EOL;
	$text .= '</script>' . PHP_EOL;
	$text .= '<table id="table">' . PHP_EOL;

	for($i = 1; $i <= $size; $i++) {
		$text .= '<tr>' . PHP_EOL;
		
		for ($j = 1; $j <= $size; $j++) {
			$text .= '<td class="cell"><table>' . PHP_EOL;
			for($notk = 0; $notk < ceil(($size)/3); $notk++ ) {
				$text .= '<tr>' . PHP_EOL;
			
				for($k = $notk*3+1; $k <= min(($notk+1)*3,$size); $k++) {
					$text .= '<td><button id="' . $i . $j . $k . '" class="numberbutton" onclick="ruleout(' . $i . ',' . $j . ',' . $k . ')">' . $k . '</button></td>' . PHP_EOL;
				}
			
				$text .= '</tr>' . PHP_EOL;
			}
			$text .= '</table></td>' . PHP_EOL;
		}
		
		$text .= '</tr>' . PHP_EOL;
	}

	$text .= '</table>' . PHP_EOL;
	$text .= '<button id="reset" onclick="reset(' . $size . ')">Reset the table</button>' . PHP_EOL;
	$text .= '<input type="checkbox" id="mode" value="eliminate" onchange="changemode()" checked>Eliminate candidates</input>' . PHP_EOL;
	$text .= '<button id="undo" onclick="undo()">Undo</button>' . PHP_EOL;
	$text .= '<button id="redo" onclick="redo()">Redo</button>' . PHP_EOL;
	
	return $text;
}

add_shortcode( 'latinsquare', 'djv_latinSquare_shortcode' );

/* --------------------- Functions for updating plugins ------------------------------ */
function djv_latinSquare_get_remote_update_from( $urlbase, $slug ) {
 $url = $urlbase . '/wp-content/uploads/jsons/' . $slug . '.json';
 $remote =  wp_remote_get( $url, array( 'timeout' => 10, 'headers' => array( 'Accept' => 'application/json' ) ) );
 if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
  $remote['urlbase'] = $urlbase;
 }
 return $remote;
}
function djv_latinSquare_get_remote_update_info( $slug ) {
 $remote = get_transient( 'djv_update_' . $slug );
 if (false == $remote) {
  if ( 'cubi' == gethostname() ) {
   $remote = djv_latinSquare_get_remote_update_from( 'http://cubi.internal', $slug );
   if (false !== $remote) {
    set_transient( 'djv_update_' . $slug, $remote, 10 ); // Save for only 10 seconds here
   }
  }
 }
 if (false == $remote || is_wp_error($remote) || !isset( $remote['response']['code'] ) || 200 !== $remote['response']['code'] || empty( $remote['body'] ) ) {
  $remote = djv_latinSquare_get_remote_update_from( 'https://blog.tremlas.com', $slug );
  set_transient( 'djv_update_' . $slug, $remote, 43200 ); // Save for 12 hours
 }
 if ( !is_wp_error( $remote ) && isset( $remote['response']['code'] ) && 200 == $remote['response']['code'] && ! empty( $remote['body'] ) ) {
  $body = json_decode( $remote['body'] );
  $info = new StdClass();
  $info->name = 'Latin Squares';
  $info->slug = $slug;
  $info->version = $body->version;
  $info->requires = $body->requires;
  $info->author = '<a href="' . $body->author_profile . '">' . $body->author . '</a>';
  $info->download_link = $remote['urlbase'] . '/' . $body->download_url;
  $info->trunk = $remote['urlbase'] . '/' . $body->download_url;
  $info->last_updated = $body->last_updated;
  $info->sections = array(
    'description'  => implode( "\n", $body->sections->description ),
    'installation' => implode( "\n", $body->sections->installation ),
    'changelog'    => implode( "\n", $body->sections->changelog ),
  );
  $info->homepage = $remote['urlbase'] . '/' . $body->homepage;
  return $info;
 }
 return false;
}

function djv_latinSquare_check_for_update( $name, $slug ) {
 $info = djv_latinSquare_get_remote_update_info( $slug );
 if ( false == $info ) {
  return false;
 }
 if ( version_compare( '3.76.0', $info->version, '<' ) && version_compare( $info->requires, get_bloginfo( 'version' ), '<' ) ) {
  $update = (object) array(
    'id'            => $name,
    'slug'          => $slug,
    'plugin'        => $name,
    'new_version'   => $info->version,
    'url'           => $info->homepage,
    'package'       => $info->download_link,
    'icons'         => array(),
    'banners'       => array(),
    'banners_rtl'   => array(),
    'tested'        => '',
    'requires_php'  => '',
    'compatability' => new StdClass()
  );
  return $update;
 } else {
  return false;
 }
}

function djv_latinSquare_pre_set_site_transient_update_plugins( $transient ) {
 // Check for update
 $pluginphp = 'latinSquares/latinSquarePlugin.php';
 $pluginslug = 'latinSquares';
 $update = djv_latinSquare_check_for_update( $pluginphp, $pluginslug );
 if ( $update ) {
  $transient->response[$pluginphp] = $update;
 } else {
  // No update
  $item = (object) array(
    'id'            => $pluginphp,
    'slug'          => $pluginslug,
    'plugin'        => $pluginphp,
    'new_version'   => '3.76.0',
    'url'           => '',
    'package'       => '',
    'icons'         => array(),
    'banners'       => array(),
    'banners_rtl'   => array(),
    'tested'        => '',
    'requires_php'  => '',
    'compatability' => new StdClass()
  );
  $transient->no_update[$pluginphp] = $item;
 }
 return $transient;
}
add_filter( 'pre_set_site_transient_update_plugins', 'djv_latinSquare_pre_set_site_transient_update_plugins' );

function djv_latinSquares_plugin_info( $result, $action, $args ) {
 $slug = 'latinSquares';
 if ( 'plugin_information' !== $action ) {
  return $result;
 }
 if ( $slug !== $args->slug) {
  return $result;
 }
 return djv_latinSquare_get_remote_update_info( $slug );
}
add_filter( 'plugins_api', 'djv_latinSquares_plugin_info', 10, 3 );
?>