//
// © 2015 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
function LatinSquare(a) {
    var size = (a instanceof LatinSquare ? a.state.length : a);
    this.state = new Array(size);
    for(var row = 0; row < this.state.length; row++) {
        this.state[row] = new Array(size);
        for(var col = 0; col < this.state[row].length; col++) {
            this.state[row][col] = new Array(size);
            for(var chosen = 0; chosen < this.state[row][col].length; chosen++) {
                this.state[row][col][chosen] = (a instanceof LatinSquare ? a.state[row][col][chosen] : true);
            }
        }
    }
}

LatinSquare.prototype.size = function() {
    return this.state.length;
};

LatinSquare.prototype.equals = function(that) {
    if (that === null) { return false; }
    if (that.constructor !== LatinSquare) { return false; }
    if (this === that) { return true; }
    if (this.state.length !== that.state.length) { return false; }
    for(var row = 0; row < this.state.length; row++) {
        if (this.state[row].length !== that.state[row].length) { return false; }
        for(var col = 0; col < this.state[row].length; col++) {
            if (this.state[row][col].length !== that.state[row][col].length) { return false; }
            for(var chosen = 0; chosen < this.state[row][col].length; chosen++) {
                if (this.state[row][col][chosen] !== that.state[row][col][chosen]) { return false; }
            }
        }
    }
    return true;
};

LatinSquare.prototype.available = function(i,row,col,chosen) {
    if (i === undefined) { return this.state[row][col][chosen]; }
    if (row === undefined) { row = i; }
    if (col === undefined) { col = i; }
    if (chosen === undefined) { chosen = i; }
    return this.state[row][col][chosen];
};

LatinSquare.prototype.ruleout = function(row,col,chosen) {
    if (this.state[row][col][chosen]) {
        var result = new LatinSquare(this);
        result.state[row][col][chosen] = false;
        return result;
    } else {
        return this;
    }
};

LatinSquare.prototype.dochoose = function(result,row,col,chosen) {
    if (this.state[row][col][chosen]) {
        if (!result) { result = new LatinSquare(this); }
        result.state[row][col][chosen] = false;
    }
    return result;
};

LatinSquare.prototype.choose = function(row,col,chosen) {
    var result;
    for(var i=0; i < this.state.length; i++) {
        if (i !== row)    { result = this.dochoose(result,i,col,chosen); }
        if (i !== col )   { result = this.dochoose(result,row,i,chosen); }
        if (i !== chosen) { result = this.dochoose(result,row,col,i); }
    }
    if (result) {
        return result;
    } else {
        return this;
    }
};

LatinSquare.prototype.remaining = function(row,col,chosen) {
    var remain = [];
    for(var i=0; i<this.state.length; i++) {
       if (this.available(i,row,col,chosen)) { remain.push(i); }
    }
    return remain;
};

LatinSquare.prototype.check = function(row,col,chosen) {
    var a = this.remaining(row,col,chosen);
    if (a.length !== 1) { return this; }
    if (row === undefined) { return this.choose(a[0],col,chosen); }
    if (col === undefined) { return this.choose(row,a[0],chosen); }
    return this.choose(row,col,a[0]);
};

LatinSquare.prototype.check2 = function(row,col) {
    var result = new LatinSquare(this);
    var a= [];
    for(var i=0; i < this.state.length; i++) {
        var r = (row === undefined ? i : row);
        var c = (col === undefined ? i : col);
        a[i] = this.remaining(r,c,undefined).sort();
    }
    for(i=0; i < this.state.length-1; i++) {
        if (a[i].length === 2) {
            for(var j=i+1; j < this.state.length; j++) {
                if (a[j].length === 2) {
                    if ((a[i][0] === a[j][0]) && (a[i][1] === a[j][1])) {
                        for(var k=0; k < this.state.length; k++) {
                            if ((i !== k) && (j !== k)) {
                                var r2 = (row === undefined ? k : row);
                                var c2 = (col === undefined ? k : col);
                                result.state[r2][c2][a[i][0]] = false;
                                result.state[r2][c2][a[i][1]] = false;
                            }
                        }
                    }
                }
            }
        }
    }
    return result;
};
