/*!
 * © 2014 David Vines
 *
 * Creative Commons License
 *
 * This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
 */

/* globals LatinSquare */
/* exported ruleout, reset, undo, redo, changemode */

var eliminate = true;
var state;
var statepos;

function ruleout(row,col,chosen) {
    state[statepos+1] = new LatinSquare(state[statepos]);
    statepos++;
    var newstate = (eliminate ? state[statepos].ruleout(row-1,col-1,chosen-1) : state[statepos].choose(row-1,col-1,chosen-1));
    while(!state[statepos].equals(newstate)) {
        state[statepos] = newstate;
        for(var i=1; state[statepos].equals(newstate) && i<=state[statepos].size(); i++) {
            for(var j=1; state[statepos].equals(newstate) && j<=state[statepos].size(); j++) {
                newstate = newstate.check(undefined,i-1,j-1);
                newstate = newstate.check(i-1,undefined,j-1);
                newstate = newstate.check(i-1,j-1,undefined);
            }
        }
        for(i=1; state[statepos].equals(newstate) && i<=state[statepos].size(); i++) {
            newstate = newstate.check2(i-1,undefined);
            newstate = newstate.check2(undefined,i-1);
        }
    }
    state.length = statepos+1;
    display();
}

function display() {
    for(var i=1; i<=state[statepos].size(); i++) {
        for(var j=1; j<=state[statepos].size(); j++) {
            var onlyk = null;
            for(var k=1; k<=state[statepos].size(); k++) {
                document.getElementById(i.toString()+j.toString()+k.toString()).disabled = !state[statepos].available(undefined,i-1,j-1,k-1);
                document.getElementById(i.toString()+j.toString()+k.toString()).className = "nc";
                if (state[statepos].available(undefined,i-1,j-1,k-1)) {
                    if (onlyk === null) {
                        onlyk = k;
                    } else {
                        onlyk = undefined;
                    }
                }
            }
            
            if (onlyk !== undefined) {
                document.getElementById(i.toString()+j.toString()+onlyk.toString()).className = "nc selected";
                document.getElementById(i.toString()+j.toString()+onlyk.toString()).disabled = true;
            }
        }
    }
    document.getElementById("undo").disabled = (statepos === 0);
    document.getElementById("redo").disabled = (statepos === state.length-1);

}

function reset(size) {
    eliminate = true;
    state = new Array(1);
    state[0] = new LatinSquare(size);
    statepos = 0;
    document.getElementById("mode").checked = eliminate;
    display();
}

function undo() {
    if (statepos > 0) {
        statepos--;
        display();
    }
}

function redo() {
    if (statepos < state.length-1) {
        statepos++;
        display();
    }
}

function changemode() {
    eliminate = document.getElementById("mode").checked;
}
