<?php
/**
 * Create A Simple Theme Options Panel
 *
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
 exit;
}

// Start Class
if ( ! class_exists( 'Ningxia_Theme_Options' ) ) {

 class Ningxia_Theme_Options {

  /**
   * Start things up
   *
   * @since 1.0.0
   */
  public function __construct() {
  
   // We only need to register the admin panel on the back-end
   if ( is_admin() ) {
    add_action( 'admin_menu', array( 'Ningxia_Theme_Options', 'add_admin_menu' ) );
    add_action( 'admin_init', array( 'Ningxia_Theme_Options', 'register_settings' ) );
   }
  
  }
  
  /**
   * Returns all theme options
   *
   * @since 1.0.0
   */
  public static function get_theme_options() {
   return get_option( 'theme_options' );
  }
  
  /**
   * Returns single theme option
   *
   * @since 1.0.0
   */
  public static function get_theme_option( $id ) {
   $options = self::get_theme_options();
   if ( isset( $options[$id] ) ) {
    return $options[$id];
   }
  }
  
  /**
   * Add sub menu page
   *
   * @since 1.0.0
   */
  public static function add_admin_menu() {
   add_menu_page(
     esc_html__( 'Theme Settings', 'text-domain' ),
     esc_html__( 'Theme Settings', 'text-domain' ),
     'manage_options',
     'theme-settings',
     array( 'Ningxia_Theme_Options', 'create_admin_page' )
     );
  }
  
  /**
   * Register a setting and its sanitization callback.
   *
   * We are only registering 1 setting so we can store all options in a single option as
   * an array. You could, however, register a new setting for each option
   *
   * @since 1.0.0
   */
  public static function register_settings() {
   register_setting( 'theme_options', 'theme_options', array( 'Ningxia_Theme_Options', 'sanitize' ) );
  }
  
  /**
   * Sanitization callback
   *
   * @since 1.0.0
   */
  public static function sanitize( $options ) {
  
   // If we have options lets sanitize them
   if ( $options ) {
    // Checkbox
    if ( ! empty( $options['static'] ) ) {
     $options['static'] = 'on';
    } else {
     unset( $options['static'] ); // Remove from options if not checked
    }
   }
  
   // Return sanitized options
   return $options;
  
  }
  
  /**
   * Settings page output
   *
   * @since 1.0.0
   */
  public static function create_admin_page() { ?>
  
  			<div class="wrap">
  
  				<h1><?php esc_html_e( 'Theme Options', 'text-domain' ); ?></h1>
  
  				<form method="post" action="options.php">
  
  					<?php settings_fields( 'theme_options' ); ?>
  
  					<table class="form-table wpex-custom-admin-login-table">
  
  						<?php // Checkbox example ?>
  						<tr valign="top">
  							<th scope="row"><?php esc_html_e( 'Static Web Site', 'text-domain' ); ?></th>
  							<td>
  								<?php $value = self::get_theme_option( 'static' ); ?>
  								<input type="checkbox" name="theme_options[static]" <?php checked( $value, 'on' ); ?>> <?php esc_html_e( 'Tick if this theme is used on a site that will be statically generated.', 'text-domain' ); ?>
  							</td>
  						</tr>
  
  					</table>
  
  					<?php submit_button(); ?>
  
  				</form>
  
  			</div><!-- .wrap -->
  		<?php }
  
  	}
  }
  new Ningxia_Theme_Options();
  
  // Helper function to use in your theme to return a theme option value
  function ningxia_get_theme_option( $id = '' ) {
  	return Ningxia_Theme_Options::get_theme_option( $id );
  }