<?php
/**
 * @since ningxia 1.0.0
**/

if ( ! isset( $content_width ) ) $content_width = 900;

function ningxia_enqueue_styles() {
 $parent_style = 'ningxia-style';
 wp_enqueue_style( $parent_style, get_template_directory_uri().'/style.css');
}
add_action( 'wp_enqueue_scripts', 'ningxia_enqueue_styles' );

function ningxia_setup() {

	/*
	 * Make Twenty Fourteen available for translation.
	 *
	 * Translations can be added to the /languages/ directory.
	 * If you're building a theme based on Twenty Fourteen, use a find and
	 * replace to change 'twentyfourteen' to the name of your theme in all
	 * template files.
	 */

	load_theme_textdomain( 'ningxia', get_template_directory() . '/languages' );

	add_theme_support( 'post-thumbnails' );

	add_theme_support( 'automatic-feed-links' );
	
	register_nav_menus( array(
			'primary'  => __( 'Primary Navigation', 'ningxia'),
	        'liftoff'  => __( 'Liftoff! Navigation', 'ningxia'),
	        'en-garde' => __( 'En Garde Navigation', 'ningxia')
	) );
}
add_action( 'after_setup_theme', 'ningxia_setup' );

if ( ! function_exists( 'ningxia_paging_nav' ) ) :
/**
 * Display navigation to next/previous set of posts when applicable.
 *
 * @since ningxia 1.0.0
 *
 * @return void
 */
function ningxia_paging_nav() {
	// Don't print empty markup if there's only one page.
	if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
		return;
	}

	$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
	$pagenum_link = html_entity_decode( get_pagenum_link() );
	$query_args   = array();
	$url_parts    = explode( '?', $pagenum_link );

	if ( isset( $url_parts[1] ) ) {
		wp_parse_str( $url_parts[1], $query_args );
	}

	$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
	$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

	$format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	$format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

	// Set up paginated links.
	$links = paginate_links( array(
		'base'     => $pagenum_link,
		'format'   => $format,
		'total'    => $GLOBALS['wp_query']->max_num_pages,
		'current'  => $paged,
		'mid_size' => 1,
		'add_args' => array_map( 'urlencode', $query_args ),
		'prev_text' => __( '&larr; Previous', 'ningxia' ),
		'next_text' => __( 'Next &rarr;', 'ningxia' ),
	) );

	if ( $links ) :

	?>
		<div class="pagination loop-pagination">
			<?php echo $links; ?>
		</div><!-- .pagination -->
	<?php
	endif;
}
endif;

function ningxia_update_years() {
	$publish = (int)get_the_date( 'Y' );
	$modify = (int)get_the_modified_date( 'Y' );
	if ( isset( $GLOBALS['ningxia_year_publish'] ) ) {
		if ( $publish < $GLOBALS['ningxia_year_publish'] ) {
			$GLOBALS['ningxia_year_publish'] = $publish;
		}
	} else {
		$GLOBALS['ningxia_year_publish'] = $publish;
	}
	if ( isset( $GLOBALS['ningxia_year_modify'] ) ) {
		if ( $modify > $GLOBALS['ningxia_year_modify'] ) {
			$GLOBALS['ningxia_year_modify'] = $modify;
		}
	} else {
		$GLOBALS['ningxia_year_modify'] = $modify;
	}
}

function ningxia_scripts() {

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
		wp_enqueue_script( 'ningxia-script', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ), '20140115', true );
}
add_action( 'wp_enqueue_scripts', 'ningxia_scripts' );

function ningxia_wp_title( $title, $sep ) {
	global $paged, $page;

	if ( is_feed() ) {
		return $title;
	}

	// Add the site name.
	$title .= get_bloginfo( 'name' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) ) {
		$title = "$title $sep $site_description";
	}

	// Add a page number if necessary.
	if ( $paged >= 2 || $page >= 2 ) {
		$title = "$title $sep " . sprintf( __( 'Page %s', 'ningxia' ), max( $paged, $page ) );
	}

	return $title;
}
add_filter( 'wp_title', 'ningxia_wp_title', 10, 2 );

function ningxia_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Left Sidebar', 'ningxia' ),
		'id'            => 'sidebar-left',
		'description'   => __( 'Additional sidebar that appears on the left.', 'ningxia' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget'  => '</li>',
		'before_title'  => '<span class="widgettitle">',
		'after_title'   => '</span>',
	) );
	register_sidebar( array(
		'name'          => __( 'Right Sidebar', 'ningxia' ),
		'id'            => 'sidebar-right',
		'description'   => __( 'Main sidebar that appears on the right.', 'ningxia' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget'  => '</li>',
		'before_title'  => '<span class="widgettitle">',
		'after_title'   => '</span>',
	) );
	register_sidebar( array(
	    'name'          => __('404 Page', 'ningxia'),
	    'id'            => '404-widgets',
	    'description'   => __( 'Widgets placed here will be shown on the 404 page.', 'ningxia' ),
	    'before_widget' => '<div class="et_pb_post">',
	    'after_widget'  => '</div>',
	    'before_title'  => '<span class="widgettitle">',
	    'after_title'   => '</span>',
	) );
}
add_action( 'widgets_init', 'ningxia_widgets_init' );

// Disable texturize (smart quotes and a few other things)
add_filter( 'run_wptexturize', '__return_false' );

function ningxia_title_apply_shortcodes($title, $sep) {
 return do_shortcode($title);
}
add_filter('wp_title', 'ningxia_title_apply_shortcodes', 10, 2);

require_once( __DIR__ . '/options.php');
?>