//
// © 2014 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
Number.prototype.toRoman= function(){
    var n = Math.floor(this),val,s= '',limit= 3999,i= 0;
    var v = [1000,900,500,400,100,90,50,40,10,9,5,4,1];
    var r = ['M','CM','D','CD','C','XC','L','XL','X','IX','V','IV','I'];
    if ( n<1 || n>limit ) { return ''; }
    while(i<13){
        val= v[i];
        while(n>= val){
            n-= val;
            s+= r[i];
        }
        if (n === 0) { return s; }
        ++i;
    }
    return '';
};


function Genre(name) {
    this.name = name;
}

function GenreFunctions(defaultLanguage,months) {
    this.months = months;
    this.defaultLanguage = defaultLanguage;
}

GenreFunctions.prototype = {
    yearAsText : function(m) { return Math.floor(m/12).toString(); },
    monthAsText : function(m) { return this.months[m%12]; },
    dayAsText: function(d) { return d.getDate(); }, // Note: input parameter is a Date
    dateMonthAsText : function(m) { return this.monthAsText(m) + " " + this.yearAsText(m); },
    dayMonthYearAsText : function(d) {
        return this.dayAsText(d) + " "+ this.dateMonthAsText(this.asMonth(d));
    },
    asMonth : function(d) { return d.getFullYear()*12 + d.getMonth(); },
    getDefaultLanguage : function() { return this.defaultLanguage; }
};

Genre.prototype = {
    constructor: Genre,
    toString: function() { return this.name; },
    toJSON: function() { return this.name; },
    equals: function(that) {
        if (that === null) { return false; }
        if (that.constructor !== Genre) { return false; }
        return (this.name === that.name);
    },
    dateMonthAsText: function(m) { return this.genre[this.name].dateMonthAsText(m); },
    dayMonthYearAsText: function(t) { return this.genre[this.name].dayMonthYearAsText(new Date(t)); },
    asMonth: function(t) { return this.genre[this.name].asMonth(new Date(t)); },
    getDefaultLanguage: function() { return this.genre[this.name].getDefaultLanguage(); },
    genre: {
        "Linrodeth"    : new GenreFunctions("Athionic",undefined),
        "Luna Romana"  : new GenreFunctions("Latin",["Ianuarius", "Februarius", "Martius", "Aprilis", "Maius", "Iunius", "Iulius", "Augustus", "September", "October", "November", "December"]),
        "Contemporary" : new GenreFunctions("English",["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"])
    }
};

Genre.prototype.genre.Linrodeth.dateMonthAsText = function(m) {
    return Date.prototype.toLinrodethMonthString(m) + " " + Math.floor(m/12);
};

Genre.prototype.genre.Linrodeth.dayMonthYearAsText = function(d) {
    return d.toLinrodethDayString() + " " + d.toLinrodethYear();
};

Genre.prototype.genre.Linrodeth.asMonth = function(d) { 
    return d.toLinrodethJulianMonth();
};

Genre.prototype.genre["Luna Romana"].dayAsText = function(d) {
    // Note: input parameter is a Date
    return d.getDate().toRoman();
};

Genre.prototype.genre["Luna Romana"].yearAsText = function(m) {
    return Math.floor(m/12).toRoman();
};
