//
// © 2014 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
/* globals Character: true, alert, gametime, genrenames, genres: true, Genre */
Character = {};

Character.returnFalse = function(f) {
    return function() {
        try {
            f();
        } catch (e) {
            if (e.stack) {
                alert(e + "\n\nStack Trace\n-----------------\n" + e.stack);
            } else {
                alert(e);
            }
        }
        return false;
    };
};

Character.setIdText = function(id, text, tooltip) {
    var element = document.getElementById(id);
    var newText = document.createTextNode(text);
    if (tooltip) {
        element.title = tooltip;
    }
    if (element.hasChildNodes()) {
        element.replaceChild(newText, element.firstChild);
    } else {
        element.appendChild(newText);
    }
};

Character.setTextArea = function(field, text) {
    var element = document.getElementById(field);
    element.value = text;
    element.defaultValue = text;
};


Character.gamedaydelta = function(field,delta) {
    return Character.returnFalse(function() {
        gametime[field] += delta;
        Character.setIdText(field+"-gameday",genres[field].dayMonthYearAsText(gametime[field]));
        Character.setTextArea(field+"-newgametime",gametime[field]);
    });
} ;

Character.linkupbuttons = function(prefix) {
    Character.gamedaydelta(prefix,0)(); // Apply a zero delta to get the text fields updated
    document.getElementById(prefix+"-gamedayminus1year").onclick = Character.gamedaydelta(prefix,-365*24*60*60*1000); 
    document.getElementById(prefix+"-gamedayminus1month").onclick = Character.gamedaydelta(prefix,-30*24*60*60*1000);
    document.getElementById(prefix+"-gamedayminus1day").onclick = Character.gamedaydelta(prefix,-24*60*60*1000);
    document.getElementById(prefix+"-gamedayplus1day").onclick = Character.gamedaydelta(prefix,24*60*60*1000);
    document.getElementById(prefix+"-gamedayplus1month").onclick = Character.gamedaydelta(prefix,30*24*60*60*1000);
    document.getElementById(prefix+"-gamedayplus1year").onclick = Character.gamedaydelta(prefix,365*24*60*60*1000);
};

var genres = {};

for(var field in genrenames) {
    if (genrenames.hasOwnProperty(field)) {
        genres[field] = new Genre(genrenames[field]);
        Character.linkupbuttons(field);
    }
}