(function(API){
    API.textInBox = function(txt, options, left, bottom, right, top) {
        options = options ||{};

        var x = left;
        var y = bottom;
        
        if( options.align === "center" ) {
            // Get current font size

            var fontSize = this.internal.getFontSize();
            // Get the actual text's width
            /* You multiply the unit width of your string by your font size and divide
             * by the internal scale factor. The division is necessary
             * for the case where you use units other than 'pt' in the constructor
             * of jsPDF.
            */
            txtWidth = this.getStringUnitWidth(txt)*fontSize/this.internal.scaleFactor;

            // Calculate text's x coordinate
            x = left + ( (right-left) - txtWidth ) / 2;
        }
        
        if (options.align === "right" ) {
            // Get current font size

            var fontSize = this.internal.getFontSize();
            // Get the actual text's width
            /* You multiply the unit width of your string by your font size and divide
             * by the internal scale factor. The division is necessary
             * for the case where you use units other than 'pt' in the constructor
             * of jsPDF.
            */
            txtWidth = this.getStringUnitWidth(txt)*fontSize/this.internal.scaleFactor;

            // Calculate text's x coordinate
            x = right-txtWidth;
        }

        if (options.valign === "center") {
            var txtHeight = this.internal.getLineHeight()/this.internal.scaleFactor;

            // Calculate text's y coordinate
            y = top + ( (bottom-top) + txtHeight ) / 2 ;

        }
        
        // Draw text at x,y
        this.text(txt,x,y);
    };
})(jsPDF.API);