//
// © 2014 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
// Big 'C' Character is used to namespace the functions
//
// little 'c' character contains the character being created.

/* globals Character:true, character, Rules, options */

Character.populateStats = function(cid) {
  Character.setIdText(cid,"nametextarea",character[cid].name);
  Character.setIdText(cid,"playernametextarea",character[cid].playerName);
  Character.setIdText(cid,"genre",character[cid].genre.toString());
  for(var i=0; i<Character.allstats.length; i++) {
      if (Character.edittableStats) {
          Character.setTextArea(cid,"stats-"+Character.allstats[i],character[cid][Character.allstats[i]]);
      } else {
          Character.setIdText(cid,"stats-"+Character.allstats[i],character[cid][Character.allstats[i]]);
      }
  }
  Character.setIdText(cid,"stats-morale",character[cid].morale);
  Character.setIdText(cid,"stats-ip",character[cid].interestPoints);

  Character.setIdText(cid,"characterdescriptiontextarea",character[cid].description);

  Character.setIdText(cid,"stats-birthday",character[cid].genre.dayMonthYearAsText(character[cid].birthtime,character[cid].birthmonth));
  Character.setIdText(cid,"stats-gameday",character[cid].genre.dayMonthYearAsText(character[cid].gametime,character[cid].gamemonth));

  var lastperiodduration;
  if (character[cid].periods.length === 1) {
      lastperiodduration = character[cid].periods[character[cid].periods.length-1].endmonth;
  } else {
      lastperiodduration = character[cid].periods[character[cid].periods.length-1].endmonth - character[cid].periods[character[cid].periods.length-2].endmonth;
  }
};

Character.updateNode = function(node,i) {
    if (node.nodeType === Node.ELEMENT_NODE) {
        node.id = node.id.replace("@@",i.toString());
        if (node.name !== undefined) {
            node.name = node.name.replace("@@",i.toString());
        }
        for(var j = 0; j < node.childNodes.length; j++) {
            Character.updateNode(node.childNodes[j],i);
        }
    }
};

Character.updateForm = function(node,i) {
    if (node.nodeType === Node.ELEMENT_NODE) {
        node.id = node.id.replace("-interest0-","-interest"+i+"-");
        if (node.name !== undefined) {
            node.name = node.name.replace("-interest0-","-interest"+i+"-");
        }
        for(var j = 0; j < node.childNodes.length; j++) {
            Character.updateForm(node.childNodes[j],i);
        }
    }
};

Character.updateSkillRow = function(cid,p,interest) {
    Character.setIdText(cid,"period"+p+"-interest"+interest+"-skill",character[cid].periods[p].interests[interest].skill);
    Character.setIdText(cid,"period"+p+"-interest"+interest+"-points",character[cid].periods[p].interests[interest].ip);
    if (character[cid].periods[p].interests[interest].teacher) {
        Character.setIdText(cid,"period"+p+"-interest"+interest+"-teacher","Teacher Bonus");
    }
};

Character.addSkillRow = function(cid,p,interest) {
    Character.updateSkillRow(cid,p,interest);
};

Character.addInterestKnowingPeriod = function(cid,p,table,skillname) {
    var adding = true;
    for(var i=0; i<character[cid].periods[p].interests.length; i++) {
        if (character[cid].periods[p].interests[i].skill === skillname) {
            character[cid].periods[p].iptotal += 1;
            character[cid].periods[p].interests[i].ip += 1;
            Character.updateSkillRow(cid,p,i);
            adding = false;
        }
    }
    if (adding) {
        var next = character[cid].periods[p].interests.length;
        character[cid].periods[p].interests.push(JSON.parse(JSON.stringify(Character.templates.interest)));
        character[cid].periods[p].interests[next].skill = skillname;
        character[cid].periods[p].interests[next].ip = 1;
        character[cid].periods[p].iptotal += 1;
        Character.addInterestRow(cid,p,table,next);
    }
    Character.populateSkills(cid);
    Character.populateJSON(cid);
};

Character.populatePeriods = function(cid) {
    // Delete the old periods
    var i = 0;
    var period = document.getElementById("c"+cid+"-period"+i);
    while(period) {
        Character.deleteElement(cid,period);
        i++;
        period = document.getElementById("c"+cid+"-period"+i);
    }

    // And build new ones
    var periods = document.getElementById("c"+cid+"-periods");
    var template = document.getElementById("c"+cid+"-period@@");

    for(i = 0; i < character[cid].periods.length; i++) {
        var newNode = template.cloneNode(true);
        newNode.className = "tabbertab";
        newNode.title = character[cid].periods[i].title;
        Character.updateNode(newNode,i);
        periods.parentNode.insertBefore(newNode,periods);
        
        // Header fields
        Character.setIdText(cid,"period"+i+"-descriptiontextarea",character[cid].periods[i].description);
        
        // dates
        Character.setIdText(cid,"period"+i+"-startdate","Age: "+Character.durationLength(character[cid].periods[i].startmonth),character[cid].genre.dateMonthAsText(character[cid].periods[i].startmonth+character[cid].birthmonth));
        Character.setIdText(cid,"period"+i+"-enddate","Age: "+Character.durationLength(character[cid].periods[i].endmonth),character[cid].genre.dateMonthAsText(character[cid].periods[i].endmonth+character[cid].birthmonth));
        Character.setIdText(cid,"period"+i+"-enddatelength"," A period of "+Character.durationLength(character[cid].periods[i].endmonth - character[cid].periods[i].startmonth  + 1));
        
        Character.populatePeriodMonths(cid,i);
        
        // childhood fluency
        if (character[cid].periods[i].startmonth > 180) {
            Character.deleteElement(cid,document.getElementById("c"+cid+"-period"+i+"-fluencyheader"));
            Character.deleteElement(cid,document.getElementById("c"+cid+"-period"+i+"-fluencycontent"));
        } else {
            Character.setIdText(cid,"period"+i+"-childhoodfluencylanguage",character[cid].periods[i].childhoodLanguage);
            Character.updateFluencyPoints(cid,i);
        }
        
        // Interests
        var table = document.getElementById("c"+cid+"-period"+i+"-details").firstChild.nextSibling;
        for(var interest=0; interest < character[cid].periods[i].interests.length; interest++) {
            Character.addInterestRow(cid,i,table,interest);
        }
        Character.updateStatus(cid,i);
    }
    
    Character.updateTabs(cid);
};

Character.addOtherSkill = function(cid,name,stats) {
    if (name !== "") {
        Rules.addSkill(name,stats);
        var newSkills = {};
        newSkills[name] = stats;
        character[cid].newSkills.push(newSkills);
    }
    
    // And give the character the skill if they're on a period
    Character.addInterest(cid,name)();
};

Character.populateJSON = function(cid) {
};

Character.resetOtherSkillsList = function(cid) {
};

Character.setupButtons = function(cid) {
};

for(var charindex = 0; charindex < options.ids.length; charindex++) {
    Character.initPage(options.ids[charindex]); // Page first so that the new skills (if any) get loaded
    Character.populateAll(options.ids[charindex]);
}
