//
// © 2014 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
/* globals Rules: true */
Rules = {};

Rules.version = "0.12.0.1";

Rules.d10 = function() {
    return Math.ceil(Math.random()*10);
};

Rules.baseStat = function() {
    return Math.round((Rules.d10()+Rules.d10()+Rules.d10())*2/3)+(Rules.d10()-1)/10;
};

Rules.newCharacter = function() {
    return { "str":  Rules.baseStat(),
             "dex":  Rules.baseStat(),
             "agi":  Rules.baseStat(),
             "con":  Rules.baseStat(),
             "app":  Rules.baseStat(),
             "int":  Rules.baseStat(),
             "wit":  Rules.baseStat(),
             "will": Rules.baseStat()
           };
};


Rules.startingMorale = function(character) {
    return Math.floor(100 + character.con*2+character.will+0.502); // fuzz factor to account for binary arithmetic
};

Rules.interestPoints = function(character) {
    return 25 + Math.floor(character["int"]/2); // jshint ignore:line
};

Rules.woundPoints = function(character) {
            //  0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19 20
    var leg   = [undefined, 7, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9,10,10,10,10,10,10];
    var abdo  = [undefined, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8];
    var chest = [undefined, 9, 9,10,10,10,11,11,11,11,11,12,12,12,13,13,13,13,14,14,15];
    var arm   = [undefined, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9];
    var head  = [undefined, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7];

    var index = Math.floor(character.con);

    return { leftLeg:   leg  [index],
             rightLeg:  leg  [index],
             abdomen:   abdo [index],
             chest:     chest[index],
             swordArm:  arm  [index],
             shieldArm: arm  [index],
             head:      head [index]
           };
};


Rules.damageTable = [];
    
Rules.damageTable[1] = [ "01-05", "06-50", "51-00"];
Rules.damageTable[2] = [ "01-05", "06-21", "22-50", "51-90", "91-00"];
Rules.damageTable[3] = [ "01-05", "06-14", "15-29", "30-50", "51-81", "82-96", "97-00"];
Rules.damageTable[4] = [ "01-05", "06-11", "12-21", "22-34", "35-50", "51-74", "75-90", "91-97", "98-00"];
Rules.damageTable[5] = [ "01-05", "06-09", "10-16", "17-26", "27-37", "38-50", "51-70", "71-85", "86-94", "95-98", "99-00"];
Rules.damageTable[6] = [ "01-05", "06-09", "10-14", "15-21", "22-29", "30-39", "40-50", "51-67", "68-81", "82-90", "91-96", "97-98", "99-00"];
Rules.damageTable[7] = [ "01-05", "06-08", "09-12", "13-17", "18-24", "25-32", "33-41", "42-50", "51-64", "65-77", "78-87", "88-93", "94-97", "98-99", "00"];
Rules.damageTable[8] = [ "01-05", "06-07", "08-11", "12-15", "16-21", "22-27", "28-34", "35-42", "43-50", "51-63", "64-74", "75-83", "84-90", "91-95", "96-97", "98-99", "00"];
Rules.damageTable[9] = [ "01-05", "06-07", "08-10", "11-14", "15-18", "19-23", "24-29", "30-36", "37-43", "44-50", "51-61", "62-72", "73-81", "82-88", "89-92", "93-96", "97-98", "99", "00"];
Rules.damageTable[10]= [ "01-05", "06-07", "08-09", "10-12", "13-16", "17-21", "22-26", "27-31", "32-37", "38-43", "44-50", "51-60", "61-70", "71-78", "79-85", "86-90", "91-94", "95-97", "98",       "99",    "00"];
Rules.damageTable[11]= [ "01-05", "06-07", "08-09", "10-12", "13-15", "16-18", "19-23", "24-27", "28-33", "34-38", "39-44", "45-50", "51-59", "60-68", "69-76", "77-83", "84-88", "89-92", "93-95", "96-97", "98-00"];
Rules.damageTable[12]= [ "01-05", "06-07", "08-09", "10-11", "12-14", "15-17", "18-21", "22-25", "26-29", "30-34", "35-39", "40-45", "46-50", "51-59", "60-67", "68-74", "75-81", "82-86", "87-90", "91-93", "94-00"];
Rules.damageTable[13]= [ "01-05", "06"   , "07-08", "09-10", "11-13", "14-16", "17-19", "20-22", "23-26", "27-31", "32-35", "36-40", "41-45", "46-50", "51-58", "59-65", "66-72", "73-79", "80-84", "85-88", "89-00"];
Rules.damageTable[14]= [ "01-05", "06"   , "07-08", "09-10", "11-12", "13-15", "16-17", "18-21", "22-24", "25-28", "29-32", "33-36", "37-41", "42-45", "46-50", "51-57", "58-64", "65-71", "72-77", "78-82", "83-00"];
Rules.damageTable[15]= [ "01-05", "06"   , "07-08", "09"   , "10-11", "12-14", "15-16", "17-19", "20-22", "23-26", "27-29", "30-33", "34-37", "38-41", "42-46", "47-50", "51-57", "58-64", "65-70", "71-76", "77-00"];
for(var i=1; i<16; i++) {
    while(Rules.damageTable[i].length < 21) {
        Rules.damageTable[i].push("");
    }
}

Rules.skilllist = {
        'Generic' : {
            "Acting/Disguise": ["wit","dex"],
            "Art/Craft": ["dex"],
            "Bribery": ["wit"],
            "Climbing": ["agi"],
            "Carousing": ["con","will"],
            "Cooking": ["wit","dex"],
            "Dancing": ["agi"],
            "Etiquette/Fashion": ["wit","app"],
            "Farming": ["will"],
            "Filching, Burglary": ["agi","dex"],
            "Gambling": ["wit","int"],
            "Horsemanship": ["agi"],
            "Interrogation": ["will","int"],
            "Leadership": ["will"],
            "Musician": ["dex"],
            "Numeracy": ["int"],
            "Oratory": ["wit"],
            "Seamanship": ["agi"],
            "Seduction": ["app"],
            "Smith": ["str", "dex"],
            "Streetwise": ["wit"],
            "Swimming": ["con"],
            "Stealth": ["agi"],
            "Survival": ["will","str"],
            "Tactics": ["wit"],
            "Tracking, Hunting": ["agi","wit"]
        },
        'Combat': {
            "Archery": ["dex"],
            "Brawling": ["str"],
            "Club, Mace, Axe": ["str"],
            "Knife (incl. Throwing)": ["dex"],
            "Sword": ["agi","str"],
            "Spear, Lance": ["agi","str"],
            "Sling": ["dex"],
            "Staff, Pole Arm": ["str"]
        },
        "Intellectual": {
            "Cartography": ["dex","int"],
            "Engineering": ["will","int"],
            "Law": ["will","int"],
            "Navigation": ["int","wit"],
            "Physician": ["int","wit"]
        },
        'Linrodeth': {
            "Bardic magic": ["int"],
            "Demonology": ["will"],
            "Divination": ["wit"],
            "Ecology": ["int","wit"],
            "Etiquette/Fashion": ["wit","app"],
            "Fluency(Athionic)": ["int"],
            "Fluency(Babel)": ["int"],
            "Fluency(City States)": ["int"],
            "Fluency(Kinjuru)": ["int"],
            "Fluency(Noord)": ["int"],
            "Fluency(Solistel)": ["int"],
            "Herbalism": ["wit"],
            "Intrigue(Civic)": ["wit"],
            "Intrigue(Court)": ["wit"],
            "Intrigue(Hahn)": ["wit"],
            "Literacy(Athionic)": ["int"],
            "Literacy(Babel)": ["int"],
            "Literacy(City States)": ["int"],
            "Literacy(Kinjuru)": ["int"],
            "Literacy(Noord)": ["int"],
            "Literacy(Solistel)": ["int"],
            "Necromancy": ["will"],
            "Ritual(Aldur)": ["will"],
            "Ritual(Brynette)": ["will"],
            "Ritual(Daleth)": ["will"],
            "Ritual(Espreyanna)": ["will"],
            "Ritual(Hahn)": ["will"],
            "Ritual(Resh)": ["will"],
            "Ritual(Torian)": ["will"],
            "Sorcery": ["int"],
            "Spirit Magic": ["wit"],
            "Theology(Aldur)": ["int"],
            "Theology(Brynette)": ["int"],
            "Theology(Daleth)": ["int"],
            "Theology(Espreyanna)": ["int"],
            "Theology(Hahn)": ["int"],
            "Theology(Resh)": ["int"],
            "Theology(Torian)": ["int"],
            "Waggoner": ["str"],
            "War Engine": ["int"]
        },
        'Linrodeth Guild': {
            "Apothecary": ["int"],
            "Baker & Pastrier": ["dex"],
            "Bowyer": ["dex"],
            "Brewer & Hosteller": ["dex"],
            "Broiderer": ["dex"],
            "Carpenter": ["dex"],
            "Chandler": ["wit"],
            "Cooper": ["dex"],
            "Clothworker & Weaver": ["dex"],
            "Cornmonger": ["wit"],
            "Dairier": ["wit"],
            "Drapers & Tailors": ["dex"],
            "Dyer": ["int","wit"],
            "Fishmonger": ["wit"],
            "Fletcher": ["wit"],
            "Fruiterer": ["wit"],
            "Glazier": ["dex"],
            "Goldsmith": ["dex"],
            "Grosser": ["int","wit"],
            "Mason": ["dex"],
            "Meatmonger": ["wit"],
            "Mercer": ["int","wit"],
            "Necromancy": ["will"],
            "Painter": ["dex"],
            "Plasterer": ["dex"],
            "Poulterer": ["wit"],
            "Saddler & Harnesser": ["dex"],
            "Shipwright": ["dex"],
            "Skinner & Leatherseller": ["wit"],
            "Sorcery": ["int"],
            "Spirit Magic": ["wit"],
            "Thatcher": ["dex"],
            "Vintner": ["int","wit"],
            "Watermen": ["dex","agi"]
        },
        'Luna Romana': {
            "Comms & Media": ["wit"],
            "Driving": ['dex','agi'],
            "Etiquette & Civilities": ["will"],
            "EVA / Zero-G": ["agi"],
            "Fashion": ["wit", "app"],
            "Fluency(Egyptian)": ["int"],
            "Fluency(Greek)": ["int"],
            "Fluency(Han)": ["int"],
            "Fluency(Indian)": ["int"],
            "Fluency(Latin)": ["int"],
            "Fluency(Mayan)": ["int"],
            "Fluency(Norse)": ["int"],
            "Humanities": ["int"],
            "Intrigue(Imperial Court)": ["wit"],
            "Literacy(Egyptian)": ["int"],
            "Literacy(Greek)": ["int"],
            "Literacy(Han)": ["int"],
            "Literacy(Indian)": ["int"],
            "Literacy(Latin)": ["int"],
            "Literacy(Mayan)": ["int"],
            "Literacy(Norse)": ["int"],
            "Mechanic": ["dex"],
            "Nautical": ["agi", "int"],
            "Performance": ["app", "wit"],
            "Piloting": ["wit", "dex"],
            "Research & Analysis": ["int","wit"],
            "Sport": ["agi"]
        },
        "Luna Romana Martial Skills": {
            "Gladius (Sword)": ["agi","str"],
            "Granatum": ["dex"],
            "Missiles": ["wit"],
            "Pilum (Rifle)": ["dex"],
            "Railgun": ["wit"],
            "Ships weapons": ["wit"],
            "Tripod weapons": ["int"]
        },
        "Luna Romana Service skills": {
            "Bureaucracy": ["int"],
            "Economics": ["int"],
            "Education": ["int", "will"],
            "Mathematics": ["int"],
            "Natural Philosophy": ["int"],
            "Theology(Luna Romana)": ["int", "will"]
        },
        "Contemporary skills": {
            "Fluency(English)": ["int"],
            "Fluency(French)": ["int"],
            "Fluency(German)": ["int"],
            "Fluency(Mandarian)": ["int"],
            "Fluency(Spanish)": ["int"],
            "Fluency(Russian)": ["int"],
            "Literacy(English)": ["int"],
            "Literacy(French)": ["int"],
            "Literacy(German)": ["int"],
            "Literacy(Mandarian)": ["int"],
            "Literacy(Spanish)": ["int"],
            "Literacy(Russian)": ["int"]
        },
        "Added skills" : {}
};

Rules.resetAddedSkills = function() {
    for(var i in Rules.skilllist["Added skills"]) {
        if (Rules.skilllist["Added skills"].hasOwnProperty(i)) {
            delete Rules.skilllist["Added skills"][i];
            delete Rules.skills[i];
        }
    }
};

Rules.addSkill = function(name,stats) {
    var added = (Rules.skills[name] === undefined);
    Rules.skilllist["Added skills"][name] = stats;
    Rules.skills[name] = stats;
    return added;
};

Rules.isKnownSkill = function(name) {
    return (Rules.skills[name] !== undefined);
};

Rules.skills = {};
for(var i in Rules.skilllist) {
    if (Rules.skilllist.hasOwnProperty(i)) {
        for(var j in Rules.skilllist[i]) {
            if (Rules.skilllist[i].hasOwnProperty(j)) {
                Rules.skills[j] = Rules.skilllist[i][j];
            }
        }
    }
}



Rules.skillround = function(skill) {
    return Math.floor(skill*10)/10;
};

Rules.skilllevel = function(name,sheet,dps) {
    // Avoid problems in the newtonian estimate below if the dps is negative (and handle the really easy case :)
    if (dps <= 0) {
        return 0; 
    }
    var stat = 0;
    for(var i=0; i<Rules.skills[name].length; i++) {
        if (sheet[Rules.skills[name][i]] > stat) {
            stat = sheet[Rules.skills[name][i]];
        }
    }
    var base = Math.pow(6000,1+0.0992063206*(15-stat)/15);
    var guess = 10;
    var makeguess = function(guess,dps,base) { 
        return guess - (3*guess*guess*guess+38*guess*guess+40*guess-40000*dps/base) / (9*guess*guess + 76*guess + 40); 
    };
    var newguess = makeguess(guess,dps,base);
    while(Rules.skillround(guess) !== Rules.skillround(newguess)) {
        guess = newguess;
        newguess = makeguess(guess,dps,base);
    }
    return Rules.skillround(guess);
};

Rules.adjectives = [ "Humiliating", "Embarrassing", "Useless",    "Poor",        "Inadequate", "Mediocre",
                                    "Adequate",     "Sufficient", "Competent",   "Proficient", "Capable",
                                    "Skillful",     "Effective",  "Admirable",   "Excellent",  "Impressive",
                                    "Superb",       "Brilliant",  "Astonishing", "Amazing",    "Awesome" ];

Rules.adj = function(perf) {
    if (perf < 0)  { perf = 0;  }
    if (perf > 20) { perf = 20; }
    perf = Math.floor(perf);
    return Rules.adjectives[perf];
};

Rules.normal = function(x,mean,sd) {
    var X = (x-mean)/sd;
    var T=1/(1+0.2316419*Math.abs(X));
    var D=0.3989423*Math.exp(-X*X/2);
    var Prob=D*T*(0.3193815+T*(-0.3565638+T*(1.781478+T*(-1.821256+T*1.330274))));
    if (X>0) {
        Prob=1-Prob;
    }
    return Math.round(Prob*100000)/100000;
};

Rules.performance = function(skill) {
    var mean = 0.65*skill+3;
    var sdlow  = 3.77-0.0585*skill;
    var sdhigh = 2.60+0.0585*skill;
    var rolls = [];
    
    var nextneed = 1;
    var totext = function(x) {
        if (x === 100) { return "00"; } else { return ("00"+x).slice(-2); }
    };
    for(var perf=0; perf<=20; perf++) {
        if (nextneed === 101) {
            rolls[perf] = "";
        } else {
            // Force truncation for column 20
            var need = (perf === 20) ? 100 : Math.round(Rules.normal(perf,mean, (perf < mean ? sdlow : sdhigh))*100);
            if ((nextneed > 1) && (need < nextneed)) { need = nextneed; } // Cope with the small range high end tails
            if (need < 1) {
                rolls[perf] = "";
            } else if (nextneed === need) {
                rolls[perf] = totext(need);
            } else {
                rolls[perf] = totext(nextneed)+"-"+totext(need); 
            }
            nextneed = need+1;
        }
    }

    return rolls;
};

Rules.genres = ["Linrodeth", "Luna Romana", "Contemporary"];

Rules.defaultweapons = [];
Rules.defaultweapons.push({name: "Unarmed",          genre:Rules.genres,    damage: 1});

Rules.weapons = [];
Rules.weapons.push({name: "Mace",             genre:["Linrodeth"],              damage: 3});
Rules.weapons.push({name: "Staff",            genre:["Linrodeth"],              damage: 3});
Rules.weapons.push({name: "Rapier",           genre:["Linrodeth"],              damage: 3});
Rules.weapons.push({name: "Short Sword",      genre:["Linrodeth"],              damage: 4});
Rules.weapons.push({name: "Gladius",          genre:["Luna Romana"],            damage: 4});
Rules.weapons.push({name: "Sabre",            genre:["Linrodeth"],              damage: 4});
Rules.weapons.push({name: "Broadsword",       genre:["Linrodeth"],              damage: 5});
Rules.weapons.push({name: "Bastard Sword",    genre:["Linrodeth"],              damage: 6});
Rules.weapons.push({name: "Mentesh Sword",    genre:["Linrodeth"],              damage: 7});
Rules.weapons.push({name: "Great Sword",      genre:["Linrodeth"],              damage: 7});
Rules.weapons.push({name: "Hand Axe",         genre:Rules.genres,               damage: 3});
Rules.weapons.push({name: "Pole Axe",         genre:["Linrodeth"],              damage: 7});
Rules.weapons.push({name: "Halberd",          genre:["Linrodeth"],              damage: 7});
Rules.weapons.push({name: "Horse Lance",      genre:["Linrodeth"],              damage: 10});
Rules.weapons.push({name: "Club",             genre:Rules.genres,               damage: 2, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,undefined,undefined,undefined,     3   ,     4   ,     5   ,     6   ,     7   ,     8   ,     9   ,    10   ,    11   ,    12   ,    13   ,    14   ,  15]});
Rules.weapons.push({name: "Knife",            genre:Rules.genres,               damage: 3, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,     8   ,     9   ,    10   ,    11   ,    12   ,    13   ,    14   ,    15   ,    16   ,    17   ,    18   ,    19   ,undefined,undefined,undefined,  20]});
Rules.weapons.push({name: "Spear",            genre:["Linrodeth"],              damage: 5, ranged: true, ranges: [undefined,undefined,undefined,undefined,    15   ,    18   ,undefined,    20   ,undefined,    25   ,undefined,    30   ,undefined,    35   ,undefined,    40   ,undefined,    45   ,undefined,    50   ,  55]});
Rules.weapons.push({name: "Pilum (Spear)",    genre:["Luna Romana"],            damage: 5, ranged: true, ranges: [undefined,undefined,undefined,undefined,    15   ,    18   ,undefined,    20   ,undefined,    25   ,undefined,    30   ,undefined,    35   ,undefined,    40   ,undefined,    45   ,undefined,    50   ,  55]});
Rules.weapons.push({name: "Battle Axe",       genre:Rules.genres,               damage: 6, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,undefined,     3   ,     4   ,     5   ,     6   ,     7   ,     8   ,     9   ,    10   ,    11   ,    12   ,    13   ,    14   ,undefined,undefined,  15]});
Rules.weapons.push({name: "Sling",            genre:["Linrodeth"],              damage: 3, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,undefined,    25   ,    35   ,    50   ,    60   ,    75   ,    75   ,   100   ,   110   ,   125   ,   135   ,   150   ,   160   ,   175   ,   185   , 200]});
Rules.weapons.push({name: "Short Bow",        genre:["Linrodeth"],              damage: 4, ranged: true, ranges: [undefined,undefined,undefined,undefined,    30   ,    35   ,    40   ,    45   ,    50   ,    55   ,    60   ,    65   ,    70   ,    75   ,    80   ,    85   ,    90   ,    95   ,   100   ,   105   , 110]});
Rules.weapons.push({name: "Long Bow",         genre:["Linrodeth"],              damage: 6, ranged: true, ranges: [undefined,undefined,undefined,undefined,    40   ,    50   ,    60   ,    70   ,    80   ,    90   ,   100   ,   110   ,   120   ,   130   ,   140   ,   150   ,   160   ,   170   ,   180   ,   190   , 200]});
Rules.weapons.push({name: "Crossbow",         genre:[],                         damage: 6, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,    40   ,    45   ,    50   ,    55   ,    60   ,    65   ,    70   ,    75   ,    80   ,    85   ,    90   ,    95   ,   100   ,   105   ,   110   , 115]});
Rules.weapons.push({name: "Heavy Crossbow",   genre:[],                         damage: 7, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,    30   ,    45   ,    60   ,    75   ,    90   ,   105   ,   120   ,   135   ,   150   ,   165   ,   180   ,   195   ,   210   ,   225   ,   240   , 250]});
Rules.weapons.push({name: "Flintlock pistol", genre:[],                         damage: 6, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,undefined,undefined,undefined,     8   ,     9   ,    10   ,    11   ,    12   ,    13   ,    14   ,    15   ,    16   ,    17   ,    18   ,    19   ,  20]});
Rules.weapons.push({name: "Musket",           genre:[],                         damage: 7, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,undefined,undefined,undefined,    15   ,    20   ,    30   ,    35   ,    45   ,    50   ,    60   ,    65   ,    75   ,    80   ,    90   ,    95   , 100]});
Rules.weapons.push({name: "Pistol", genre:["Luna Romana","Contemporary"],       damage: 6, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,     9   ,    12   ,    15   ,    18   ,undefined,    20   ,    25   ,undefined,    30   ,undefined,    35   ,    40   ,undefined,    45   ,undefined,  50]});
Rules.weapons.push({name: "Rifle",            genre:["Contemporary"],           damage: 8, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,    40   ,    70   ,   100   ,   130   ,   160   ,   190   ,   220   ,   250   ,   280   ,   310   ,   340   ,   370   ,   400   ,   430   ,   460   , 490]});
Rules.weapons.push({name: "Pilum (Rifle)",    genre:["Luna Romana"],            damage: 8, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,    40   ,    70   ,   100   ,   130   ,   160   ,   190   ,   220   ,   250   ,   280   ,   310   ,   340   ,   370   ,   400   ,   430   ,   460   , 490]});
Rules.weapons.push({name: "Sniper Rifle", genre:["Luna Romana","Contemporary"], damage: 10,ranged: true, ranges: [undefined,undefined,undefined,undefined,   100   ,   175   ,   300   ,   425   ,   550   ,   675   ,   800   ,   925   ,  1050   ,  1175   ,  1300   ,  1425   ,  1550   ,  1675   ,  1800   ,  1925   ,2000]});
Rules.weapons.push({name: "Machine Gun", genre:["Luna Romana","Contemporary"],  damage: 6, ranged: true, ranges: [undefined,undefined,undefined,    30   ,    40   ,    50   ,    60   ,    70   ,    80   ,    90   ,   100   ,   110   ,   120   ,   130   ,   140   ,   150   ,   160   ,   170   ,   180   ,   190   , 200], hits:2});
Rules.weapons.push({name: "Heavy MG", genre:["Luna Romana","Contemporary"]    , damage: 8, ranged: true, ranges: [undefined,undefined,undefined,    50   ,    75   ,   100   ,   125   ,   150   ,   175   ,   200   ,   225   ,   250   ,   275   ,   300   ,   325   ,   350   ,   375   ,   400   ,   425   ,   450   , 475], area: 3, hits: 2});
Rules.weapons.push({name: "Grenade", genre:["Luna Romana","Contemporary"],      damage: 9, ranged: true, ranges: [undefined,undefined,undefined,undefined,undefined,undefined,    35   ,undefined,undefined,    40   ,undefined,    45   ,undefined,undefined,    50   ,undefined,    55   ,undefined,undefined,undefined,  60], area: 5, hits: 3});
Rules.weapons.push({name: "Zero G Gun",       genre:["Luna Romana"],            damage: 7, ranged: true, ranges: [undefined,undefined,undefined,   200   ,   250   ,   300   ,   350   ,   400   ,   450   ,   500   ,   550   ,   600   ,   650   ,   700   ,   750   ,   800   ,   850   ,   900   ,   950   ,undefined,1000]});
Rules.weapons.push({name: "Pilum Novus",      genre:["Luna Romana"],            damage: 7, ranged: true, ranges: [undefined,undefined,undefined,   200   ,   250   ,   300   ,   350   ,   400   ,   450   ,   500   ,   550   ,   600   ,   650   ,   700   ,   750   ,   800   ,   850   ,   900   ,   950   ,undefined,1000]});
Rules.weapons.push({name: "Ray Gun",          genre:[],                         damage: 8, ranged: true, ranges: [undefined,undefined,   300   ,   400   ,   500   ,   600   ,   700   ,   800   ,   900   ,  1000   ,  1100   ,  1200   ,  1300   ,  1400   ,  1500   ,  1600   ,  1700   ,  1800   ,  1900   ,undefined,2000]});
Rules.weapons.push({name: "Plasma Pistol",    genre:[],                         damage: 8, ranged: true, ranges: [undefined,undefined,     5   ,     8   ,    10   ,    13   ,    15   ,    18   ,undefined,    20   ,undefined,    25   ,undefined,    30   ,undefined,    35   ,undefined,    40   ,undefined,    45   ,  50], area: 3, hits: 2});
Rules.weapons.push({name: "Plasma Rifle",     genre:[],                         damage: 8, ranged: true, ranges: [undefined,undefined,    45   ,undefined,    50   ,undefined,    55   ,undefined,    60   ,undefined,    65   ,undefined,    70   ,undefined,    75   ,undefined,    80   ,undefined,    85   ,undefined,  90], area: 8, hits: 4});

Rules.weapons.sort(function(a,b) { if (a.name<b.name) { return -1; } if (a.name>b.name) { return 1; } else { return 0; }});

Rules.armour = [];
Rules.armour.push({name: "None",    genre: Rules.genres, value: 0});
Rules.armour.push({name: "Leather", genre: ["Linrodeth","Luna Romana"], value: 1});
Rules.armour.push({name: "Scale",   genre: ["Linrodeth"], value: 2});
Rules.armour.push({name: "Chain",   genre: ["Linrodeth"], value: 3});
Rules.armour.push({name: "Steel",   genre: ["Luna Romana"], value: 3});
Rules.armour.push({name: "Superior Chain", genre: ["Linrodeth"], value: 4});
Rules.armour.push({name: "Ceramic", genre: ["Luna Romana"], value: 5});
Rules.armour.push({name: "Zero G Combat", genre: ["Luna Romana"], value: 6});

Rules.shields = [];
Rules.shields.push({name: "No Shield", text: "Having no shield means no locations are protected by a shield.", genre: Rules.genres, value: 0, locations: 0});
Rules.shields.push({name: "Light Shield", text: "Having a light shield protects the left arm and an additional location.", genre: ["Linrodeth", "Luna Romana"], value: 2, locations: 1});
Rules.shields.push({name: "Medium Shield", text: "Having a medium shield protects the left arm, the chest and an additional location.",genre: ["Linrodeth", "Luna Romana"], value: 3, locations: 2});
Rules.shields.push({name: "Heavy Shield", text: "Having a heavy shield protects the left arm, head, chest and abdomen.",genre: ["Linrodeth", "Luna Romana"], value: 4, locations: 3});