//
// © 2014 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
/* globals Character: true, alert, character: true, Genre */
Character = {};

Character.returnFalse = function(f) {
    return function() {
        try {
            f();
        } catch (e) {
            if (e.stack) {
                alert(e + "\n\nStack Trace\n-----------------\n" + e.stack);
            } else {
                alert(e);
            }
        }
        return false;
    };
};

Character.setIdText = function(id, text, tooltip) {
    var element = document.getElementById(id);
    var newText = document.createTextNode(text);
    if (tooltip) {
        element.title = tooltip;
    }
    if (element.hasChildNodes()) {
        element.replaceChild(newText, element.firstChild);
    } else {
        element.appendChild(newText);
    }
};

Character.setTextArea = function(field, text) {
    var element = document.getElementById(field);
    element.value = text;
    element.defaultValue = text;
};


Character.gamedaydelta = function(delta) {
    return Character.returnFalse(function() {
        character.gametime += delta;
        Character.setIdText("stats-gameday",character.genre.dayMonthYearAsText(character.gametime));
        Character.setTextArea("newgametime",character.gametime);
    });
} ;

character.genre = new Genre(character.initial_genre);
Character.setIdText("stats-gameday",character.genre.dayMonthYearAsText(character.gametime));

document.getElementById("gamedayminus1year").onclick = Character.gamedaydelta(-365*24*60*60*1000); 
document.getElementById("gamedayminus1month").onclick = Character.gamedaydelta(-30*24*60*60*1000);
document.getElementById("gamedayminus1day").onclick = Character.gamedaydelta(-24*60*60*1000);
document.getElementById("gamedayplus1day").onclick = Character.gamedaydelta(24*60*60*1000);
document.getElementById("gamedayplus1month").onclick = Character.gamedaydelta(30*24*60*60*1000);
document.getElementById("gamedayplus1year").onclick = Character.gamedaydelta(365*24*60*60*1000);

document.getElementById("djv_genre").onchange = Character.returnFalse(function() {
    var sc = document.getElementById("djv_genre");
    character.genre = new Genre(sc[sc.selectedIndex].text);
    Character.setIdText("stats-gameday",character.genre.dayMonthYearAsText(character.gametime));
});
