//
// © 2014 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//
// Big 'C' Character is used to namespace the functions
//
// little 'c' character contains the character being created.

/* globals Character: true, character: true, options, alert, Rules, Genre */
Character.populateStats = function(cid) {
    var i;
    Character.setTextArea(cid,"nametextarea",character[cid].name);
    Character.setTextArea(cid,"playernametextarea",character[cid].playerName);
    Character.setOption(document.getElementById("c"+cid+"-genre"),character[cid].genre.toString());
    for(i=0; i<Character.allstats.length; i++) {
        if (Character.edittableStats) {
            Character.setTextArea(cid,"stats-"+Character.allstats[i],character[cid][Character.allstats[i]]);
    } else {
        Character.setIdText(cid,"stats-"+Character.allstats[i],character[cid][Character.allstats[i]]);
        }
    }
    Character.setIdText(cid,"stats-morale",character[cid].morale);
    Character.setIdText(cid,"stats-ip",character[cid].interestPoints);

    Character.setTextArea(cid,"characterdescriptiontextarea",character[cid].description);

    Character.setIdText(cid,"stats-birthday",character[cid].genre.dayMonthYearAsText(character[cid].birthtime,character[cid].birthmonth));
    Character.setIdText(cid,"stats-gameday",character[cid].genre.dayMonthYearAsText(character[cid].gametime,character[cid].gamemonth));

    if (character[cid].statslock) {
        Character.deleteElement(cid,"birthdayminus1year");
        Character.deleteElement(cid,"birthdayminus1month");
        Character.deleteElement(cid,"birthdayminus1day");
        Character.deleteElement(cid,"birthdayplus1day");
        Character.deleteElement(cid,"birthdayplus1month");
        Character.deleteElement(cid,"birthdayplus1year");
        Character.deleteElement(cid,"lockform");
        for(i=0; i<Character.allstats.length; i++) {
            Character.deleteElement(cid,Character.allstats[i]+"swap");
        }
    }

    document.getElementById("c"+cid+"-gamedatesync").checked = character[cid].syncWithGlobalDate;
    document.getElementById("c"+cid+"-gamedatesync").defaultChecked = character[cid].syncWithGlobalDate;
    document.getElementById("c"+cid+"-gamedayminus1year").disabled = character[cid].syncWithGlobalDate;
    document.getElementById("c"+cid+"-gamedayminus1month").disabled = character[cid].syncWithGlobalDate;
    document.getElementById("c"+cid+"-gamedayminus1day").disabled = character[cid].syncWithGlobalDate;
    document.getElementById("c"+cid+"-gamedayplus1day").disabled = character[cid].syncWithGlobalDate;
    document.getElementById("c"+cid+"-gamedayplus1month").disabled = character[cid].syncWithGlobalDate;
    document.getElementById("c"+cid+"-gamedayplus1year").disabled = character[cid].syncWithGlobalDate;
};

Character.updateNode = function(node,i) {
    if (node.nodeType === Node.ELEMENT_NODE) {
        node.id = node.id.replace("@@",i.toString());
        if (node.name !== undefined) {
            node.name = node.name.replace("@@",i.toString());
        }
        for(var j = 0; j < node.childNodes.length; j++) {
            Character.updateNode(node.childNodes[j],i);
        }
    }
};

Character.updateForm = function(node,i) {
    if (node.nodeType === Node.ELEMENT_NODE) {
        node.id = node.id.replace("-interest0-","-interest"+i+"-");
        if (node.name !== undefined) {
            node.name = node.name.replace("-interest0-","-interest"+i+"-");
        }
        for(var j = 0; j < node.childNodes.length; j++) {
            Character.updateForm(node.childNodes[j],i);
        }
    }
};

Character.updateEndDate = function(cid,p,delta) {
    return Character.returnFalse(function() {
        character[cid].periods[p].endmonth += delta;
        character[cid].periods[p].endmonthtext = character[cid].genre.dateMonthAsText(character[cid].periods[p].endmonth+character[cid].birthmonth);
        if (character[cid].periods[p+1]) {
            // Update start of next period
            character[cid].periods[p+1].startmonth = character[cid].periods[p].endmonth+1;
            character[cid].periods[p+1].startmonthtext = character[cid].genre.dateMonthAsText(character[cid].periods[p+1].startmonth+character[cid].birthmonth);
            // Future period now at zero or negative length?, if so we need to bump its end month too
            if (character[cid].periods[p+1].startmonth > character[cid].periods[p+1].endmonth) {
                    // By just enough to make it one month in length
                    Character.updateEndDate(cid, p+1, character[cid].periods[p+1].startmonth - character[cid].periods[p+1].endmonth + 1);
            }
        }
        Character.incrementVersion(cid);
        Character.populatePeriods(cid);
        Character.populateSkills(cid);
      });
};

Character.updateFluency = function(cid,p,fc) {
    return Character.returnFalse(function() {
        character[cid].periods[p].childhoodLanguage = fc[fc.selectedIndex].text;
        Character.incrementVersion(cid);
        Character.populateSkills(cid);
    });
};

Character.updatePoints = function(cid,p,i,delta) {
    return Character.returnFalse(function() {
        character[cid].periods[p].interests[i].ip += delta;
        character[cid].periods[p].iptotal += delta;
        Character.updateSkillRow(cid,p,i);
        Character.updateSkillRowButtons(cid,p);
        Character.updateStatus(cid,p);
        Character.incrementVersion(cid);
        Character.populateSkills(cid);
    });
};

Character.updateTeacher = function(cid,p,i,sc) {
    return Character.returnFalse(function() {
        character[cid].periods[p].interests[i].teacher = sc.checked;
        Character.incrementVersion(cid);
        Character.populateSkills(cid);
    });
};

Character.updateSkillRowButtons = function(cid,p) {
    for(var i=0; i<character[cid].periods[p].interests.length; i++) {
        var interestup = document.getElementById("c"+cid+"-period"+p+"-interest"+i+"-ipup");
        var interestdown = document.getElementById("c"+cid+"-period"+p+"-interest"+i+"-ipdown");
        interestup.disabled = (character[cid].periods[p].iptotal >= character[cid].interestPoints);
        interestdown.disabled = (character[cid].periods[p].interests[i].ip < 1);
    }
};

Character.updateSkillRow = function(cid,p,interest) {
    var interestteacher = document.getElementById("c"+cid+"-period"+p+"-interest"+interest+"-teacher");
    Character.setIdText(cid,"period"+p+"-interest"+interest+"-skill",character[cid].periods[p].interests[interest].skill);
    Character.setIdText(cid,"period"+p+"-interest"+interest+"-points",character[cid].periods[p].interests[interest].ip);
    Character.setChecked(interestteacher,character[cid].periods[p].interests[interest].teacher);
};

Character.deleteInterest = function(cid,p,interest) {
    return Character.returnFalse(function() {
        character[cid].periods[p].iptotal -= character[cid].periods[p].interests[interest].ip;
        character[cid].periods[p].interests.splice(interest,1);
        for(var i=interest; i<character[cid].periods[p].interests.length; i++) {
            Character.updateSkillRow(cid,p,i);
        }
        var row = document.getElementById("c"+cid+"-period"+p+"-interest"+character[cid].periods[p].interests.length);
        Character.deleteElement(cid,row);
        Character.updateSkillRowButtons(cid,p);
        Character.updateStatus(cid,p);
        Character.incrementVersion(cid);
        Character.populateSkills(cid);
    });
};

Character.addSkillRow = function(cid,p,interest) {
    Character.updateSkillRow(cid,p,interest);
    var interestup = document.getElementById("c"+cid+"-period"+p+"-interest"+interest+"-ipup");
    var interestdown = document.getElementById("c"+cid+"-period"+p+"-interest"+interest+"-ipdown");
    var interestteacher = document.getElementById("c"+cid+"-period"+p+"-interest"+interest+"-teacher");
    var interestdelete = document.getElementById("c"+cid+"-period"+p+"-interest"+interest+"-delete");
    interestup.onclick = Character.updatePoints(cid,p,interest,1);
    interestdown.onclick = Character.updatePoints(cid,p,interest,-1);
    interestteacher.onchange = Character.updateTeacher(cid,p,interest,interestteacher);
    interestdelete.onclick = Character.deleteInterest(cid,p,interest);
};

Character.addInterestKnowingPeriod = function(cid,p,table,skillname) {
    var adding = true;
    for(var i=0; i<character[cid].periods[p].interests.length; i++) {
        if (character[cid].periods[p].interests[i].skill === skillname) {
            character[cid].periods[p].iptotal += 1;
            character[cid].periods[p].interests[i].ip += 1;
            Character.updateSkillRow(cid,p,i);
            adding = false;
        }
    }
    if (adding) {
        var next = character[cid].periods[p].interests.length;
        character[cid].periods[p].interests.push(JSON.parse(JSON.stringify(Character.templates.interest)));
        character[cid].periods[p].interests[next].skill = skillname;
        character[cid].periods[p].interests[next].ip = 1;
        character[cid].periods[p].iptotal += 1;
        Character.addInterestRow(cid,p,table,next);
    }
    Character.updateSkillRowButtons(cid,p);
    Character.populateSkills(cid);
    Character.populateJSON(cid);
};

Character.populatePeriodTitle = function(cid,p,li) {
    return Character.returnFalse(function() {
        var newtitle = document.getElementById("c"+cid+"-period"+p+"-titletextarea").value;
        character[cid].periods[p].title = newtitle;
        Character.setIdText(cid,"sheetnav"+li,newtitle);
        document.getElementById("c"+cid+"-sheetnav"+li).title = newtitle;
        Character.incrementVersion(cid);
        Character.populateJSON(cid);
    });
};

Character.populatePeriodDescription = function(cid,p) {
    return Character.returnFalse(function() {
        character[cid].periods[p].description =  document.getElementById("c"+cid+"-period"+p+"-descriptiontextarea").value;
        Character.incrementVersion(cid);
        Character.populateJSON(cid);
    });
};

Character.populatePeriods = function(cid) {    
    // Delete the old periods
    var i = 0;
    var period = document.getElementById("c"+cid+"-period"+i);
    while(period) {
        Character.deleteElement(cid,period);
        i++;
        period = document.getElementById("c"+cid+"-period"+i);
    }

    // And build new ones
    var periods = document.getElementById("c"+cid+"-periods");
    var template = document.getElementById("c"+cid+"-period@@");
    var agemonths = character[cid].gamemonth - character[cid].birthmonth;

    for(i = 0; i < character[cid].periods.length; i++) {
        var newNode = template.cloneNode(true);
        newNode.className = "tabbertab";
        newNode.title = character[cid].periods[i].title;
        Character.updateNode(newNode,i);
        periods.parentNode.insertBefore(newNode,periods);
        
        // Header fields
        Character.setTextArea(cid,"period"+i+"-titletextarea",character[cid].periods[i].title);
        Character.setTextArea(cid,"period"+i+"-descriptiontextarea",character[cid].periods[i].description);
        
        // dates
        Character.setIdText(cid,"period"+i+"-startdate","Age: "+Character.durationLength(character[cid].periods[i].startmonth),character[cid].genre.dateMonthAsText(character[cid].periods[i].startmonth+character[cid].birthmonth));
        Character.setIdText(cid,"period"+i+"-enddate","Age: "+Character.durationLength(character[cid].periods[i].endmonth),character[cid].genre.dateMonthAsText(character[cid].periods[i].endmonth+character[cid].birthmonth));
        Character.setIdText(cid,"period"+i+"-enddatelength"," A period of "+Character.durationLength(character[cid].periods[i].endmonth - character[cid].periods[i].startmonth  + 1));
        document.getElementById("c"+cid+"-period"+i+"-titletextarea").onchange = Character.populatePeriodTitle(cid,i,i+3);
        document.getElementById("c"+cid+"-period"+i+"-descriptiontextarea").onchange = Character.populatePeriodDescription(cid,i);
        
        document.getElementById("c"+cid+"-period"+i+"-enddateminus1year").onclick = Character.updateEndDate(cid,i,-12);
        document.getElementById("c"+cid+"-period"+i+"-enddateminus1month").onclick = Character.updateEndDate(cid,i,-1);
        document.getElementById("c"+cid+"-period"+i+"-enddateplus1month").onclick = Character.updateEndDate(cid,i,1);
        document.getElementById("c"+cid+"-period"+i+"-enddateplus1year").onclick = Character.updateEndDate(cid,i,12);
        
        Character.populatePeriodMonths(cid,i);
        
        // childhood fluency
        if (character[cid].periods[i].startmonth > 180) {
            Character.deleteElement(cid,document.getElementById("c"+cid+"-period"+i+"-fluencyheader"));
            Character.deleteElement(cid,document.getElementById("c"+cid+"-period"+i+"-fluencycontent"));
        } else {
            Character.updateFluencyPoints(cid,i);
            var fluencyChoice = document.getElementById("c"+cid+"-period"+i+"-childhoodfluencylanguage");
            Character.setOption(fluencyChoice,character[cid].periods[i].childhoodLanguage);
            fluencyChoice.onchange = Character.updateFluency(cid,i,fluencyChoice);
        }
        
        // Interests
        var table = document.getElementById("c"+cid+"-period"+i+"-details").firstChild.nextSibling;
        for(var interest=0; interest < character[cid].periods[i].interests.length; interest++) {
            Character.addInterestRow(cid,i,table,interest);
        }
        Character.updateSkillRowButtons(cid,i);
        
        Character.updateStatus(cid,i);
    }
    
    Character.updateTabs(cid);
};

Character.populateJSON = function(cid) {
    Character.setTextArea(cid,"JSONtextarea",JSON.stringify(character[cid],undefined,2));
};

Character.birthdaydelta = function(cid,delta) {
    return Character.returnFalse(function() {
        character[cid].birthtime += delta;
        character[cid].birthmonth = character[cid].genre.asMonth(character[cid].birthtime);
        character[cid].birthmonthtext = character[cid].genre.dateMonthAsText(character[cid].birthmonth);
        character[cid].birthday = character[cid].genre.dayMonthYearAsText(character[cid].birthtime,character[cid].birthmonth);
        character[cid].periods[character[cid].periods.length-1].endmonth = character[cid].gamemonth - character[cid].birthmonth;
        for(var i=0; i<character[cid].periods.length; i++) {
            character[cid].periods[i].startmonthtext = character[cid].genre.dateMonthAsText(character[cid].periods[i].startmonth+character[cid].birthmonth);
            character[cid].periods[i].endmonthtext = character[cid].genre.dateMonthAsText(character[cid].periods[i].endmonth+character[cid].birthmonth);
        }
        Character.incrementVersion(cid);
        Character.populateAll(cid); // all the dates will have shifted in sympathy
    });
} ;

Character.gamedaydelta = function(cid,delta) {
    return Character.returnFalse(function() {
        character[cid].gametime += delta;
        character[cid].gamemonth = character[cid].genre.asMonth(character[cid].gametime);
        character[cid].gamemonthtext = character[cid].genre.dateMonthAsText(character[cid].gamemonth);
        character[cid].gameday = character[cid].genre.dayMonthYearAsText(character[cid].gametime,character[cid].gamemonth);
        character[cid].periods[character[cid].periods.length-1].endmonth = character[cid].gamemonth - character[cid].birthmonth;
        character[cid].periods[character[cid].periods.length-1].endmonthtext = character[cid].gamemonthtext;
        Character.incrementVersion(cid);
        Character.populateAll(cid); // The last period will have changed length (possibly to a negative length)
    });
} ;

Character.updateDerivedStats = function(cid) {
    character[cid].morale = Rules.startingMorale(character[cid]);
    character[cid].woundPoints = Rules.woundPoints(character[cid]);
    character[cid].interestPoints = Rules.interestPoints(character[cid]);
    for(var p=0; p<character[cid].periods.length; p++) {
        character[cid].periods[p].iptotal = 0;
        for(var i=0; i<character[cid].periods[p].interests.length; i++) {
            character[cid].periods[p].iptotal += character[cid].periods[p].interests[i].ip;
        }
        Character.updateStatus(cid,p);
    }
    Character.populateAll(cid);
};

Character.statSwap = function(cid,stat,sc) {
    return  Character.returnFalse(function() {
        var option = sc[sc.selectedIndex].text;
        if (option === "") {
            return;
        }
        var shorthand = { "Strength": "str",
                          "Dexterity": "dex",
                          "Agility": "agi",
                          "Constitution": "con",
                          "Appearance": "app",
                          "Intellect": "int",
                          "Wit": "wit",
                          "Will": "will"
                        };
        var that = shorthand[option];
        var other = character[cid][that];
        character[cid][that] = character[cid][stat];
        character[cid][stat] = other;
        Character.updateDerivedStats(cid);
        Character.incrementVersion(cid);
        sc.selectedIndex = 0;
    });
};

Character.resetOtherSkillsList = function(cid) {
    var DOM_h4 = document.getElementById("c"+cid+"-skills-category-"+encodeURI("Added skills"));
    if (DOM_h4) {
        var DOM_table = DOM_h4.nextSibling;
        var DOM_tbody = DOM_table.firstChild;
        Character.deleteAllChildren(DOM_tbody);
    }
};

Character.addOtherSkill = function(cid,name,stats) {
    if (name !== "") {
        Rules.addSkill(name,stats);
        
        if (character[cid].newSkills.every(function(x) { return x[name] === undefined; })) {
            var newSkills = {};
            newSkills[name] = stats;
            character[cid].newSkills.push(newSkills);
        }
        
        // Finally add a button for it - if the table for the buttons exists
        var DOM_h4 = document.getElementById("c"+cid+"-skills-category-"+encodeURI("Added skills"));
        var DOM_table, DOM_tbody, DOM_tr, DOM_td;
        if (DOM_h4) {
            DOM_table = DOM_h4.nextSibling;
            DOM_tbody = DOM_table.firstChild;
            if (!DOM_tbody.lastChild || DOM_tbody.lastChild.lastChild.lastChild) {
                // Empty space on last row
                DOM_tr = document.createElement("tr");
                DOM_td = document.createElement("td");
                DOM_td.appendChild(Character.createButton(name,Character.addInterest(cid,name)));
                DOM_tr.appendChild (DOM_td);
                DOM_td = document.createElement("td");
                DOM_tr.appendChild(DOM_td);
                DOM_tbody.appendChild(DOM_tr);
            } else {
                DOM_td = DOM_tbody.lastChild.lastChild;
                DOM_td.appendChild(Character.createButton(name,Character.addInterest(cid,name)));
            }
        }
    }
    
    // And give the character the skill if they're on a period
    Character.addInterest(cid,name)();
};

Character.init = function(cid) {
    // Copy across the form fields to the ones actually sent (in the hidden diff)
    Character.setTextArea(cid,"djv_nametextarea",character[cid].name);
    Character.setTextArea(cid,"djv_genre",character[cid].genre.toString());
    Character.setTextArea(cid,"djv_playernametextarea",character[cid].playerName);

    
    // Populate the skill list div with buttons
    var skilllist = document.getElementById("c"+cid+"-skilllist").parentNode;
    var childhoodfluency = document.getElementById("c"+cid+"-period@@-childhoodfluencylanguage");
    var DOM_h4, DOM_form, DOM_table, DOM_tbody, DOM_tr, DOM_td, DOM_button, DOM_option;
    for(var category in Rules.skilllist) {
        if (Rules.skilllist.hasOwnProperty(category)) {
            DOM_h4 = document.createElement("h4");
            DOM_h4.appendChild(document.createTextNode(category));
            DOM_h4.id = "c"+cid+"-skills-category-"+encodeURI(category); // to encode the blanks
            skilllist.appendChild(DOM_h4);
            DOM_table = document.createElement("table");
            DOM_table.style.width = "100%";
            DOM_table.style.tableLayout = "fixed";
            DOM_tbody = document.createElement("tbody");
            DOM_tr = undefined;
            for(var skill in Rules.skilllist[category]) {
                if (Rules.skilllist[category].hasOwnProperty(skill)) {
                    DOM_td = document.createElement("td");
                    DOM_td.appendChild(Character.createButton(skill,Character.addInterest(cid,skill)));
                    // Flip-flop the cells into rows so that we get two columns
                    if (DOM_tr) {
                        DOM_tr.appendChild(DOM_td);
                        DOM_tbody.appendChild(DOM_tr);
                        DOM_tr = undefined;
                    } else {
                        DOM_tr = document.createElement("tr");
                        DOM_tr.appendChild(DOM_td);
                    }
                    if (skill.indexOf("Fluency(") === 0) {
                        var dialect = skill.slice(8,-1);
                        DOM_option = new Option(dialect,dialect,true,false);
                        childhoodfluency.appendChild(DOM_option);
                    }
                }
            }
            // one cell row at the end?
            if (DOM_tr) {
                DOM_td = document.createElement("td");
                DOM_tr.appendChild(DOM_td);
                DOM_tbody.appendChild(DOM_tr);
            }
        
            DOM_table.appendChild(DOM_tbody);
            skilllist.appendChild(DOM_table);
        }
    }
    
    // Other language
    DOM_h4 = document.createElement("h4");
    DOM_h4.appendChild(document.createTextNode("Add unlisted Language"));
    skilllist.appendChild(DOM_h4);
    DOM_form = document.createElement("form");
    DOM_table = document.createElement("table");
    DOM_table.style.width = "100%";
    DOM_table.style.tableLayout = "fixed";
    DOM_tbody = document.createElement("tbody");
    DOM_tr = document.createElement("tr");
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 3;
    DOM_td.appendChild(Character.createTextArea(cid,"skill-add-language",1,20));
    DOM_tr.appendChild(DOM_td);
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 1;
    DOM_button = Character.createButton("Add",Character.returnFalse(function(){
        var name = document.getElementById("c"+cid+"-skill-add-language").value;
        Character.addOtherSkill(cid,"Fluency("+name+")",["int"]);
        Character.addOtherSkill(cid,"Literacy("+name+")",["int"]);
    }));
    DOM_td.appendChild(DOM_button);
    DOM_tr.appendChild(DOM_td);
    DOM_tbody.appendChild(DOM_tr);
    DOM_table.appendChild(DOM_tbody);
    DOM_form.appendChild(DOM_table);
    skilllist.appendChild(DOM_form);

    // Other Religion
    DOM_h4 = document.createElement("h4");
    DOM_h4.appendChild(document.createTextNode("Add unlisted Religion"));
    skilllist.appendChild(DOM_h4);
    DOM_form = document.createElement("form");
    DOM_table = document.createElement("table");
    DOM_table.style.width = "100%";
    DOM_table.style.tableLayout = "fixed";
    DOM_tbody = document.createElement("tbody");
    DOM_tr = document.createElement("tr");
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 3;
    DOM_td.appendChild(Character.createTextArea(cid,"skill-add-religion",1,20));
    DOM_tr.appendChild(DOM_td);
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 1;
    DOM_button = Character.createButton("Add",Character.returnFalse(function(){
        var name = document.getElementById("c"+cid+"-skill-add-religion").value;
        Character.addOtherSkill(cid,"Ritual("+name+")",["will"]);
        Character.addOtherSkill(cid,"Theology("+name+")",["int"]);
    }));
    DOM_td.appendChild(DOM_button);
    DOM_tr.appendChild(DOM_td);
    DOM_tbody.appendChild(DOM_tr);
    DOM_table.appendChild(DOM_tbody);
    DOM_form.appendChild(DOM_table);
    skilllist.appendChild(DOM_form);

    // Other Ritual
    DOM_h4 = document.createElement("h4");
    DOM_h4.appendChild(document.createTextNode("Add unlisted Ritual"));
    skilllist.appendChild(DOM_h4);
    DOM_form = document.createElement("form");
    DOM_table = document.createElement("table");
    DOM_table.style.width = "100%";
    DOM_table.style.tableLayout = "fixed";
    DOM_tbody = document.createElement("tbody");
    DOM_tr = document.createElement("tr");
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 3;
    DOM_td.appendChild(Character.createTextArea(cid,"skill-add-ritual",1,20));
    DOM_tr.appendChild(DOM_td);
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 1;
    DOM_button = Character.createButton("Add",Character.returnFalse(function(){
        var name = document.getElementById("c"+cid+"-skill-add-ritual").value;
        Character.addOtherSkill(cid,"Ritual("+name+")",["will"]);
    }));
    DOM_td.appendChild(DOM_button);
    DOM_tr.appendChild(DOM_td);
    DOM_tbody.appendChild(DOM_tr);
    DOM_table.appendChild(DOM_tbody);
    DOM_form.appendChild(DOM_table);
    skilllist.appendChild(DOM_form);

    // The 'other' skills
    DOM_h4 = document.createElement("h4");
    DOM_h4.appendChild(document.createTextNode("Add Unlisted Skill"));
    skilllist.appendChild(DOM_h4);
    DOM_form = document.createElement("form");
    DOM_table = document.createElement("table");
    DOM_table.style.width = "100%";
    DOM_table.style.tableLayout = "fixed";
    DOM_tbody = document.createElement("tbody");
    DOM_tr = document.createElement("tr");
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 4;
    DOM_td.appendChild(Character.createTextArea(cid,"skill-add-name",1,24));
    DOM_tr.appendChild(DOM_td);
    DOM_tbody.appendChild(DOM_tr);
    DOM_tr = document.createElement("tr");
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 4;
    DOM_td.appendChild(document.createTextNode("Attributes"));
    DOM_tr.appendChild(DOM_td);
    DOM_tbody.appendChild(DOM_tr);
    var addStats = function(tbody,stats) {
        var DOM_tr = document.createElement("tr");
        for (var i=0; i<stats.length; i++) {
            var DOM_td = document.createElement("td");
            DOM_td.className = "right-align";
            DOM_td.appendChild(document.createTextNode(stats[i]+" "));
            var DOM_checkbox = document.createElement("input");
            DOM_checkbox.type = "checkbox";
            DOM_checkbox.id = "c"+cid+"-skill-add-"+stats[i];
            DOM_checkbox.checked = false;
            DOM_td.appendChild(DOM_checkbox);
            DOM_tr.appendChild(DOM_td);
        }
        DOM_tbody.appendChild(DOM_tr);
    };
    addStats(DOM_tbody,Character.allstats.slice(0,4));
    addStats(DOM_tbody,Character.allstats.slice(4));
    DOM_tr = document.createElement("tr");
    DOM_td = document.createElement("td");
    DOM_td.colSpan = 4;
    DOM_button = Character.createButton("Add New Skill",Character.returnFalse(function(){
        var name = document.getElementById("c"+cid+"-skill-add-name").value;
        var stats = [];
        for(var i=0; i<Character.allstats.length; i++) {
            if (document.getElementById("c"+cid+"-skill-add-"+Character.allstats[i]).checked) {
                stats.push(Character.allstats[i]);
            }
        }
        Character.addOtherSkill(cid,name,stats);
    }));
    DOM_td.appendChild(DOM_button);
    DOM_tr.appendChild(DOM_td);
    DOM_tbody.appendChild(DOM_tr);
    DOM_table.appendChild(DOM_tbody);
    DOM_form.appendChild(DOM_table);
    skilllist.appendChild(DOM_form);
};

Character.setupButtons = function(cid) {
    document.getElementById("c"+cid+"-birthdayminus1year").onclick = Character.birthdaydelta(cid,-365*24*60*60*1000); 
    document.getElementById("c"+cid+"-birthdayminus1month").onclick = Character.birthdaydelta(cid,-30*24*60*60*1000);
    document.getElementById("c"+cid+"-birthdayminus1day").onclick = Character.birthdaydelta(cid,-24*60*60*1000);
    document.getElementById("c"+cid+"-birthdayplus1day").onclick = Character.birthdaydelta(cid,24*60*60*1000);
    document.getElementById("c"+cid+"-birthdayplus1month").onclick = Character.birthdaydelta(cid,30*24*60*60*1000);
    document.getElementById("c"+cid+"-birthdayplus1year").onclick = Character.birthdaydelta(cid,365*24*60*60*1000);

    document.getElementById("c"+cid+"-gamedayminus1year").onclick = Character.gamedaydelta(cid,-365*24*60*60*1000); 
    document.getElementById("c"+cid+"-gamedayminus1month").onclick = Character.gamedaydelta(cid,-30*24*60*60*1000);
    document.getElementById("c"+cid+"-gamedayminus1day").onclick = Character.gamedaydelta(cid,-24*60*60*1000);
    document.getElementById("c"+cid+"-gamedayplus1day").onclick = Character.gamedaydelta(cid,24*60*60*1000);
    document.getElementById("c"+cid+"-gamedayplus1month").onclick = Character.gamedaydelta(cid,30*24*60*60*1000);
    document.getElementById("c"+cid+"-gamedayplus1year").onclick = Character.gamedaydelta(cid,365*24*60*60*1000);

    document.getElementById("c"+cid+"-gamedatesync").onchange = Character.returnFalse(function() {
        character[cid].syncWithGlobalDate = document.getElementById("c"+cid+"-gamedatesync").checked;
        document.getElementById("c"+cid+"-gamedayminus1year").disabled = character[cid].syncWithGlobalDate;
        document.getElementById("c"+cid+"-gamedayminus1month").disabled = character[cid].syncWithGlobalDate;
        document.getElementById("c"+cid+"-gamedayminus1day").disabled = character[cid].syncWithGlobalDate;
        document.getElementById("c"+cid+"-gamedayplus1day").disabled = character[cid].syncWithGlobalDate;
        document.getElementById("c"+cid+"-gamedayplus1month").disabled = character[cid].syncWithGlobalDate;
        document.getElementById("c"+cid+"-gamedayplus1year").disabled = character[cid].syncWithGlobalDate;
        if (character[cid].syncWithGlobalDate) {
            character[cid].gametime = options.gametime;
            character[cid].gametime = options.gametime;
            character[cid].gameday = character[cid].genre.dayMonthYearAsText(character[cid].gametime,character[cid].gamemonth);
            character[cid].gamemonth = character[cid].genre.asMonth(character[cid].gametime);
            character[cid].gamemonthtext = character[cid].genre.dateMonthAsText(character[cid].gamemonth);
            character[cid].periods[character[cid].periods.length-1].endmonth = character[cid].gamemonth - character[cid].birthmonth;
            character[cid].periods[character[cid].periods.length-1].endmonthtext = character[cid].gamemonthtext;
            Character.incrementVersion(cid);
            Character.populateAll(cid);
        }
    });
    
    document.getElementById("c"+cid+"-genre").onchange = Character.returnFalse(function() {
        var sc = document.getElementById("c"+cid+"-genre");
        var oldgenre = character[cid].genre;
        character[cid].genre = new Genre(sc[sc.selectedIndex].text);
        character[cid].birthmonth = character[cid].genre.asMonth(character[cid].birthtime);
        character[cid].gamemonth = character[cid].genre.asMonth(character[cid].gametime);
        character[cid].birthmonthtext = character[cid].genre.dateMonthAsText(character[cid].birthmonth);
        character[cid].gamemonthtext = character[cid].genre.dateMonthAsText(character[cid].gamehmonth);
        if (!character[cid].genre.equals(oldgenre)) {
            for(var i=0; i<character[cid].periods.length; i++) {
                character[cid].periods[i].childhoodLanguage = character[cid].genre.getDefaultLanguage();
            }
        }
        
        // Reset equipment
        character[cid].armour = Rules.armour[0];
        character[cid].shield = Rules.shields[0];
        character[cid].shieldLocations = [];
        character[cid].favouredWeapons = [];
        
        Character.updateMonths(cid);
        Character.setTextArea(cid,"djv_genre",character[cid].genre.toString());
        Character.incrementVersion(cid);
        Character.populateAll(cid);
    });

    document.getElementById("c"+cid+"-nametextarea").onchange = Character.returnFalse(function() {
        character[cid].name =  document.getElementById("c"+cid+"-nametextarea").value;
        Character.setTextArea(cid,"djv_nametextarea",character[cid].name);
        Character.incrementVersion(cid);
        Character.populateJSON(cid);
    });

    document.getElementById("c"+cid+"-playernametextarea").onchange = Character.returnFalse(function() {
        character[cid].playerName =  document.getElementById("c"+cid+"-playernametextarea").value;
        Character.setTextArea(cid,"djv_playernametextarea",character[cid].playerName);
        Character.incrementVersion(cid);
        Character.populateJSON(cid);
    });

    document.getElementById("c"+cid+"-characterdescriptiontextarea").onchange = Character.returnFalse(function() {
        character[cid].description =  document.getElementById("c"+cid+"-characterdescriptiontextarea").value;
        Character.incrementVersion(cid);
        Character.populateJSON(cid);
    });

    for(var i=0; i<Character.allstats.length; i++) {
        var stat = Character.allstats[i];
        document.getElementById("c"+cid+"-"+stat+"swapsel").onchange = Character.statSwap(cid,stat,document.getElementById("c"+cid+"-"+stat+"swapsel"));
    }

    document.getElementById("c"+cid+"-reroll").onclick = Character.returnFalse(function() {
        var newcharacter = Rules.newCharacter();
        for(var i=0; i<Character.allstats.length; i++) {
            character[cid][Character.allstats[i]] = newcharacter[Character.allstats[i]];
        }
        character[cid].characterVersion = 0;
        character[cid].lastEditDate = (new Date(Date.now())).toLocaleString();
        Character.updateDerivedStats(cid);
        Character.populateStats(cid);
        Character.incrementVersion(cid);
        Character.populateJSON(cid);
    });

    document.getElementById("c"+cid+"-statsedit").onclick = Character.returnFalse(function(){
        var updateStat = function(stat,element) {
            return Character.returnFalse(function() {
                character[cid][stat] = Character.validateStat(stat,element.value);
                Character.updateDerivedStats(cid);
                Character.incrementVersion(cid);
            });
        };
        for(var i=0; i<Character.allstats.length; i++) {
            var oldE = document.getElementById("c"+cid+"-stats-"+Character.allstats[i]);
            var newE = document.createElement("td");
            var textarea = document.createElement("textarea");
            textarea.value = character[cid][Character.allstats[i]];
            textarea.rows = 1;
            textarea.cols = 8;
            textarea.className = "onerow";
            textarea.onchange = updateStat(Character.allstats[i],textarea);
            textarea.id = "c"+cid+"-stats-"+Character.allstats[i];
            newE.appendChild(textarea);
            oldE.parentNode.replaceChild(newE,oldE);
            Character.deleteElement(cid,Character.allstats[i]+"swap");
        }
        document.getElementById("c"+cid+"-statsedit").disabled = true;
    });
    
    document.getElementById("c"+cid+"-statsedit").disabled = false; // Ensure enabled even after a reload of a page with it disabled
    
    document.getElementById("c"+cid+"-statslock").onclick = Character.returnFalse(function() {
        character[cid].statslock = true;
        for(var i=0; i<Character.allstats.length; i++) {
            var oldE = document.getElementById("c"+cid+"-stats-"+Character.allstats[i]);
            var newE = document.createElement("td");
            var text = document.createTextNode(character[cid][Character.allstats[i]].toString());
            newE.appendChild(text); 
            newE.id = "c"+cid+"-stats-"+Character.allstats[i];
            oldE.parentNode.replaceChild(newE,oldE);
        }
        Character.populateStats(cid);
        Character.incrementVersion(cid);
        Character.populateJSON(cid);
    });
    
    document.getElementById("c"+cid+"-addPeriod").onclick = Character.returnFalse(function() {
        var op = character[cid].periods[character[cid].periods.length-1];
        var np = JSON.parse(JSON.stringify(op));
        // Split the time in two
        var duration = Math.round((op.endmonth - op.startmonth + 1)/2);
        op.endmonth = op.startmonth + duration - 1;
        np.startmonth = op.endmonth + 1;
        op.endmonthtext = character[cid].genre.dateMonthAsText(op.endmonth+character[cid].birthmonth);
        np.startmonthtext = character[cid].genre.dateMonthAsText(np.startmonth+character[cid].birthmonth);
        np.title = "Period "+(character[cid].periods.length+1);
        np.description = "The next stage in life";
        character[cid].periods.push(np);
        Character.incrementVersion(cid);
        Character.populateAll(cid);
    });
    
    document.getElementById("c"+cid+"-startPeriod").onclick = Character.returnFalse(function() {
        var op = character[cid].periods[character[cid].periods.length-1];
        var np = JSON.parse(JSON.stringify(op));
        // Split the time in two
        np.startmonth = op.endmonth + 1;
        np.endmonth = op.endmonth;
        np.endmonthtext = character[cid].genre.dateMonthAsText(np.endmonth+character[cid].birthmonth);
        np.startmonthtext = character[cid].genre.dateMonthAsText(np.startmonth+character[cid].birthmonth);
        np.title = "Period "+(character[cid].periods.length+1);
        np.description = "The next stage in life";
        character[cid].periods.push(np);
        Character.incrementVersion(cid);
        Character.populateAll(cid);
    });

    document.getElementById("c"+cid+"-JSONtriggerfile").onclick = Character.returnFalse(function() {
        document.getElementById("c"+cid+"-JSONfile").click();
    });

    document.getElementById("c"+cid+"-JSONfile").onchange = Character.returnFalse(function() {
        var file = document.getElementById("c"+cid+"-JSONfile").files[0];
        if (file) {
            var reader = new FileReader();
            reader.onload = function() {
                if (document.getElementById("c"+cid+"-statedit")) {
                    document.getElementById("c"+cid+"-statsedit").checked = false;
                    document.getElementById("c"+cid+"-statsedit").onchange();
                }
                Character.updateWithNewJSON(reader.result,true);
                // Copy across the form fields to the ones actually sent (in the hidden diff)
                Character.populateJSON(cid);
                Character.setTextArea(cid,"djv_nametextarea",character[cid].name);
                Character.setTextArea(cid,"djv_genre",character[cid].genre.toString());
                Character.setTextArea(cid,"djv_playernametextarea",character[cid].playerName);
            };
            reader.onerror = function() {
                alert("Error reading JSON, error code:"+reader.error);
            };
            reader.readAsText(file);
        }
    });
};

for(var charindex = 0; charindex < options.ids.length; charindex++) {
    Character.initPage(options.ids[charindex]); // Page first so that the new skills (if any) get loaded
    Character.init(options.ids[charindex]);
    Character.populateAll(options.ids[charindex]);
}
