//
// © 2014 David Vines
//
// Creative Commons License
//
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//

Date.prototype.getUTCDayOfYear = Date.prototype.getUTCDayOfYear || function() {
    "use strict";
    var onejan = new Date(this.getUTCFullYear(), 0, 1);
    return Math.ceil((this - onejan) / 86400000);
};
Date.prototype.getUTCDayFraction = Date.prototype.getUTCDayFraction || function() {
    "use strict";
    return this.getUTCHours() / 24 + this.getUTCMinutes() / 1440;
};
Date.prototype.getLinrodethJulian = Date.prototype.getLinrodethJulian || function() {
    "use strict";
    return (this.getUTCFullYear() - 1991 + 142) * 365 + this.getUTCDayOfYear() - 1 + this.getUTCDayFraction() + (this.getUTCFullYear() - 1991 + 142) / 4;
};
Date.prototype.toLinrodethYear = Date.prototype.toLinrodethYear || function() {
    "use strict";
    var year;
    if (this.getUTCDayOfYear() < 32) {
        year = this.getUTCFullYear() - 1991 + 141;
    } else {
        year = this.getUTCFullYear() - 1991 + 142;
    }
    return year;
};
Date.prototype.toLinrodethDayString = Date.prototype.toLinrodethDayString || function() {
    "use strict";
    var ordinal = function(d) {
        var i = (d - 1) % 10 + 1, j = Math.ceil(d / 10), day, week;
        switch (i) {
        case 1:
            day = "FirstDay ";
            break;
        case 2:
            day = "SecondDay ";
            break;
        case 3:
            day = "ThirdDay ";
            break;
        case 4:
            day = "FourthDay ";
            break;
        case 5:
            day = "FifthDay ";
            break;
        case 6:
            day = "SixthDay ";
            break;
        case 7:
            day = "SeventhDay ";
            break;
        case 8:
            day = "EighthDay ";
            break;
        case 9:
            day = "NinthDay ";
            break;
        case 10:
            day = "TenthDay ";
            break;
        default:
            day = "ImpossibleDay(" + i + ") ";
        }
        switch (j) {
        case 1:
            week = "FirstWeek";
            break;
        case 2:
            week = "SecondWeek";
            break;
        case 3:
            week = "ThirdWeek";
            break;
        default:
            week = "ImpossibleWeek(" + j + ")";
        }
        return day + week;
    }, doy = this.getUTCDayOfYear();
    if (doy < 31) {
        return ordinal(doy) + " Kruthos";
    } else if (doy === 31) {
        return "Midwinter";
    } else if (doy < 62) {
        return ordinal(doy - 31) + " Skelern";
    } else if (doy < 92) {
        return ordinal(doy - 61) + " Galemir";
    } else if (doy < 122) {
        return ordinal(doy - 91) + " Pipetal";
    } else if (doy === 122) {
        return "Springtide";
    } else if (doy < 153) {
        return ordinal(doy - 122) + " Jasmarill";
    } else if (doy < 183) {
        return ordinal(doy - 152) + " Heliora";
    } else if (doy < 213) {
        return ordinal(doy - 182) + " Menderal";
    } else if (doy === 213) {
        return "Midsummer";
    } else if ((doy === 214) && this.isUTCLeapYear()) {
        return "Dragonfeast";
    } else {
        if (!this.isUTCLeapYear()) {
            doy++;
        }
        if (doy < 245) {
            return ordinal(doy - 214) + " Setheran";
        } else if (doy < 275) {
            return ordinal(doy - 244) + " Arvinoth";
        } else if (doy === 275) {
            return "Harvestide";
        } else if (doy < 306) {
            return ordinal(doy - 275) + " Lorinfall";
        } else if (doy < 336) {
            return ordinal(doy - 305) + " Kryll";
        } else if (doy === 336) {
            return "Ghostmoons";
        } else if (doy < 367) {
            return ordinal(doy - 336) + " Ternost";
        } else {
            return "Impossible Linrodeth Date";
        }
    }
};
// Note: Festivals are attached to the following month in this numbering scheme - also first month is zero
Date.prototype.toLinrodethMonth = Date.prototype.toLinrodethMonth || function() {
    var doy = this.getUTCDayOfYear();
    if (doy < 31) {
        return 11;
    } else if (doy === 31) {
        return 11;
    } else if (doy < 62) {
        return 0;
    } else if (doy < 92) {
        return 1;
    } else if (doy < 122) {
        return 2;
    } else if (doy === 122) {
        return 2;
    } else if (doy < 153) {
        return 3;
    } else if (doy < 183) {
        return 4;
    } else if (doy < 213) {
        return 5;
    } else if (doy === 213) {
        return 5;
    } else if ((doy === 214) && this.isUTCLeapYear()) {
        return 5;
    } else {
        if (!this.isUTCLeapYear()) {
            doy++;
        }
        if (doy < 245) {
            return 6;
        } else if (doy < 275) {
            return 7;
        } else if (doy === 275) {
            return 7;
        } else if (doy < 306) { 
            return 8;
        } else if (doy < 336) {
            return 9;
        } else if (doy === 336) {
            return 10;
        } else if (doy < 367) {
            return 10;
        } else {
            return undefined;
        }
    }
};
Date.prototype.toLinrodethJulianMonth = Date.prototype.toLinrodethJulianMonth || function() {
    return this.toLinrodethYear()*12 + this.toLinrodethMonth();
};
Date.prototype.toLinrodethMonthString = Date.prototype.toLinrodethMonthString || function(i) {
    if (i === undefined) { i = this.toLinrodethMonth(); }
    i = i % 12;
    var names = ["Skelern","Galemir","Pipetal","Jasmarill","Heliora","Menderal","Setheran","Arvinoth","Lorinfall","Kryll","Ternost","Kruthos"];
    return names[i];
};
Date.prototype.toLinrodethString = Date.prototype.toLinrodethString || function() {
    "use strict";
    return this.toLinrodethDayString() + " " + this.toLinrodethYear() + " at " + this.toLocaleTimeString();
};
Date.prototype.isUTCLeapYear = Date.prototype.isUTCLeapYear || function() {
    "use strict";
    if (this.getUTCFullYear() % 400 === 0) {
        return true;
    } else if (this.getUTCFullYear() % 100 === 0) {
        return false;
    } else {
        return (this.getUTCFullYear() % 4 === 0);
    }
};